@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('event.settings.update', Session::get('event_id')) }}"
            id="crudForm" enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Settings
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-body px-3">
                    @foreach (getEventSettingVariables() as $key)
                        @php
                            $label = ucfirst(str_replace('_', ' ', $key));
                        @endphp
                        <div class="form-group">
                            <div class="row align-items-center">
                                <div class="col-sm-2">
                                    <label>{{ __($label) }}
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" name="{{ $key }}" placeholder="Enter {{ $label }}"
                                        id="{{ $key }}" class="form-control"
                                        value="{{ old($key, getEnvironmentVariable($key,Session::get('event_id'))) }}">
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });
    </script>
@endsection
