    @extends('layouts.master')
    @section('css')
        <link rel="stylesheet" href="{{ asset('assets/css/magnific-popup.css') }}" type="text/css">
    @endsection
    @section('content')
        <div class="dashboard-body">
            <div class="cards shadow-none">
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col-xl">
                            <form action="{{ url()->current() }}" method="get">
                                <div class="row justify-content-xl-end">
                                    <div class="col mb-4">
                                        <h2 class="title-1">
                                            Speakers ({{ $speakers->total() }}) 
                                        </h2>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-xxl">
                    <div class="row">
                        <div class="col-xxl">
                            <form method="get" action="{{ url()->current() }}">
                                <div class="row justify-content-xxl-end">
                                    <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                        <input type="text" name="filter" class="form-control"
                                            placeholder="Name or contact"
                                            @if ($request->filter) value="{{ $request->filter }}" @endif>
                                    </div>
                                    <div class="col-auto mb-4">
                                        <button type="submit" class="btn btn-primary px-4">
                                            search
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                    fill="#7C8DB5" />
                                            </svg>
                                        </button>
                                    </div>
                                    <div class="col-auto mb-2">
                                        <a href="{{ route('event.speakers.create') }}"
                                            class="btn btn-outline-primary px-4">+
                                            Add new</a>
                                    </div>
                                    <div class="col-auto mb-4">
                                        <button type="button" class="btn btn-primary px-4 import-btn" data-toggle="modal"
                                            data-target="#upload">
                                            Import
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Massage -->
            <div class="table-design custom-table container-fluid py-2">
                <table class="table display mb-5">
                    <thead>
                        <th>Sr. No</th>
                        <th>Name</th>
                        <th>Contact</th>
                        <th>Institute</th>
                        <th>Designation</th>
                        <th>Type</th>
                        <th>Profile </th>
                        <th>Action</th>
                    </thead>
                    <tbody>
                        @if (count($speakers) > 0)
                            @php $i = $speakers->perPage() * ($speakers->currentPage() - 1) + 1; @endphp
                            @foreach ($speakers as $speaker)
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{ $speaker->name ?? '' }}</td>
                                    <td>{{ $speaker->contact ?? '' }}</td>
                                    <td>{{ $speaker->institute ?? '' }}</td>
                                    <td>{{ $speaker->designation ?? '' }}</td>
                                    <td>{{ $speaker->type->name ?? '' }}</td>
                                    <td>
                                        @if ($speaker->image)
                                            <div class=" w-25">
                                                <a class="image-popup-no-margins mr-2"
                                                    href="{{ getFilePath($speaker->image->path) }}">
                                                    <img src="{{ getFilePath($speaker->image->path) }}"
                                                        class="img-responsive" style="width:50px;"></a>
                                            </div>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="members-tools-button">
                                            <a href="{{ route('event.speakers.edit', $speaker->id) }}"
                                                class="btn btn-sm-icon me-3">
                                                <img src="{{ asset('assets/images/icon/edit.png') }}">
                                            </a>
                                            <button class="btn btn-sm-icon me-3"
                                                onclick="sweetAlertAjax('delete','{{ route('event.speakers.destroy', $speaker->id) }}', 'Are you sure you want to delete?')">
                                                <img src="{{ asset('assets/images/icon/delete.png') }}">
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td class="text-center" colspan="10">No Data Found </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
                {{ $speakers->appends(Request::all())->links() }}
            </div>
        </div>
        <div class="modal fade" id="myModal">
            <div class="modal-dialog">
                <div class="modal-content" style="max-width: 500px; width: 100%; margin-left: 130px;">
                    <div class="modal-header">
                        <h5 class="modal-title">Change Index</h5>
                        <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                    </div>
                    <form id="indexchange" method="POST">
                        @csrf
                        @method('PATCH')
                        <div class="modal-body">
                            <label>Enter Index</label>
                            <input type="text" class="form-control" id="index" placeholder="Enter index"
                                name="index" value="">
                            <input type="hidden" class="associationId" name="id" value="">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="modal fade" id="upload" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="uploadModalLabel">Upload File</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="uploadForm" class="custom-validation"
                            action="{{ route('event.speakers.import', Session::get('event_id')) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="mb-3">
                                <label for="fileInput" class="form-label">Choose file</label>
                                <input type="file" onchange="checkValidation(this)" name="file" id="fileInput"
                                    class="form-control fileUpload" required>
                            </div>
                        </form>
                        <div class="">
                            Download Speaker Sample File From Here: <b><a
                                    href="{{ asset('assets/excel/speaker_sample_new.xlsx') }}" download="">Speaker
                                    File</a></b>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" form="uploadForm" class="btn btn-primary">Submit</button>
                    </div>
                </div>
            </div>
        </div>
    @endsection
    @section('js')
        <script src="{{ asset('assets/js/jquery.magnific-popup.min.js') }}"></script>
        <script>
            $(document).on('click', '.index-btn', function() {
                var associationId = $(this).data('id');
                var index = $(this).data('value');

                $('#indexchange .associationId').val(associationId);
                $('#index').val(index);
                $("#myModal").modal("show");

            });

            $('#indexchange').on('submit', function(e) {
                e.preventDefault();

                var associationId = $('.associationId').val();
                var index = $('#index').val();

                var url = "{{ route('event.speakers.update.index', ':associationId') }}";
                url = url.replace(':associationId', associationId);
                $.ajax({
                    url: url,
                    method: 'patch',
                    data: {
                        id: associationId,
                        index: index,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        $('#myModal').modal('hide');
                        swal({
                            text: response.message,
                            icon: "success",
                            button: "Ok",
                        }).then(function() {
                            location.reload();
                        });
                    }
                });
            });
            checkValidation = function(event) {
                var filePath = event.value;
                var allowedExtensions = /(\.xlsx)$/i;
                if (!allowedExtensions.exec(filePath)) {
                    alert('Please upload file having extensions .xlsx only.');
                    event.value = '';
                } else {
                    if (event.files && event.files[0]) {
                        var reader = new FileReader();
                        reader.readAsDataURL(event.files[0]);
                    }
                }
            };
            $(document).on('click', '.import-btn', function() {
                $("#upload").modal("show");
            });

            $(".image-popup-no-margins").magnificPopup({
                type: "image",
                closeOnContentClick: !0,
                closeBtnInside: !1,
                fixedContentPos: !0,
                mainClass: "mfp-no-margins mfp-with-zoom",
                image: {
                    verticalFit: !0
                },
                zoom: {
                    enabled: !0,
                    duration: 300
                }
            });
        </script>
    @endsection
