@extends('layouts.master')
@section('css')
    <style>
        .color {
            height: 20px;
            width: 60px;
            border: 1px solid #000;
        }
    </style>
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Speaker Type ({{ $eventSpeakerTypes->total() }})
                                    </h2>
                                </div>

                                <div class="col-auto mb-2">
                                    <button type="button" class="btn btn-outline-primary px-4" onclick="addSpeakerType()">
                                        + Add Speaker Type
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventSpeakerTypes) > 0)
                        @php $i = $eventSpeakerTypes->perPage() * ($eventSpeakerTypes->currentPage() - 1) + 1; @endphp
                        @foreach ($eventSpeakerTypes as $eventSpeakerType)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $eventSpeakerType->name ?? '' }}</td>
                                <td>
                                    <div class="members-tools-button">
                                        <a class="btn btn-sm-icon me-3" data-id="{{ $eventSpeakerType->id }}"
                                            data-name="{{ $eventSpeakerType->name }}"
                                            onclick="editSpeakerType(this)">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.speakers.type.destroy', $eventSpeakerType->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventSpeakerTypes->appends(Request::all())->links() }}
        </div>
    </div>
    <div class="modal fade" id="addEventSpeakerTypesModal" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="model-title">Add Speaker Type</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="width: 1.5rem; height: 1.5rem;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" class="custom-validation" action="" id="editEventSpeakerTypesForm"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="">Name</label>
                                <input type="text" name="name" id="name" placeholder="Enter Name"
                                    class="form-control" data-parsley-error-message="Name is required" required>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">submit</button>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
            $('.fc-datepicker').datepicker({
                dateFormat: "dd-mm-yy",
                changeYear: true,
                changeMonth: true,
            });

            $('#addEventSpeakerTypesModal').on('hidden.bs.modal', function() {
                $('#editEventSpeakerTypesForm')[0].reset();
            });
        });

        function addSpeakerType() {
            var eventId = "{{ Session::get('event_id') }}";
            var url = "{{ route('event.speakers.type.store', ':eventId') }}";
            url = url.replace(':eventId', eventId);
            $("#model-title").html("Add Speaker Type");
            $("#name").val("");
            $("#editEventSpeakerTypesForm").find('input[name="_method"]').val('POST');
            $("#editEventSpeakerTypesForm").attr("action", url);
            $("#addEventSpeakerTypesModal").modal("show");
        }

        function editSpeakerType(button) {
            var eventSpeakerTypes = $(button).data('id');
            var name = $(button).data('name');
            var url = "{{ route('event.speakers.type.update', ':eventSpeakerTypes') }}";
            url = url.replace(':eventSpeakerTypes', eventSpeakerTypes);
            $("#model-title").html("Edit Speaker Type");
            $("#name").val(name);
            $("#editEventSpeakerTypesForm").find('input[name="_method"]').val('PUT');
            $("#editEventSpeakerTypesForm").attr("action", url);
            $("#addEventSpeakerTypesModal").modal("show");
        }
    </script>
@endsection
