<!DOCTYPE html>
<html class="wide" lang="en">

<head>
    <title>{{ 'Event '.$event->title ?? '' }}</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,height=device-height,initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="icon" href="{{ asset('assets/images/logo.png') }}" type="image/x-icon" />
    <link rel="stylesheet" type="text/css"
        href="https://fonts.googleapis.com/css?family=Barlow%7CBarlow+Condensed:300,400,500,600,700,900">
    <link href="{{ asset('assets/frontend/event/css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/frontend/event/css/fonts.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/event/css/style.css') }}">
    <style>
        .nav-link-cite {
            font-size: 16px !important;
        }
    </style>
</head>

<body>
    <div class="page">
        <!-- Section Conference Schedule-->
        <section class="section bg-default text-center pt-4">

            <div class="tabs-custom tabs-horizontal tabs-corporate" id="tabs-1">
                <!--Nav tabs-->
                <ul class="nav nav-tabs">
                    <style>
                        .tabs-custom .nav-link-35 {
                            background-color: #ff0000;
                            color: #00ffe1;
                        }
                        .tabs-custom .nav-link:hover, .tabs-custom .nav-link.active{
                            background-color:#f4f2ee !important;
                        }
                    </style>
                    @foreach ($eventDays as $key => $eventDay)
                        <li class="nav-item" role="presentation">
                            <a class="nav-link nav-link nav-link-secondary-darker @if($key == 0) active  @endif show"
                                style="background-color: {{ $eventDay->bg_color }}; color: {{ $eventDay->text_color }}" href="#{{$key}}" data-toggle="tab"
                                data-triangle=".nav-link-overlay">
                                <span class="nav-link-overlay"></span>
                                <span class="nav-link-cite">{{ $eventDay->name }} |
                                    {{ getTimezoneDateTime($eventDay->date, 'd/m/Y') }}</span>
                            </a>
                        </li>
                    @endforeach
                </ul>
                <!--Tab panes-->
                <div class="tab-content wow fadeIn">
                    @foreach ($eventDays as $key => $eventDay)
                    <div class="tab-pane fade  active @if($key == 0) show @endif" id="{{$key}}">
                        <div class="card-group-custom card-group-corporate" id="accordion35" role="tablist"
                            aria-multiselectable="false">
                            <table class="table table-bordered">
                                @foreach ($eventDay->eventParentSessions as $eventSession)
                                    <thead
                                        style="background: {{ $eventSession->bg_color ?? '#000ba8' }}; color: {{ $eventSession->text_color ?? '#ffffff' }};">
                                        <tr>
                                            <th scope="col" colspan="7">
                                                <h5 style="color: {{ $eventSession->text_color ?? '#ffffff' }};">
                                                    {{ $eventSession->title ?? '' }}</h5>
                                                <h6 style="color: {{ $eventSession->text_color ?? '#ffffff' }};">
                                                    Topic: {{ $eventSession->topic ?? '' }}</h6>

                                                @foreach ($event->eventDesignations as $eventDesignation)
                                                    @php
                                                        $eventSessionUserNames = null;
                                                        $eventSessionUserNames =
                                                            $eventSession
                                                                ->eventSessionUsers()
                                                                ->wherePivot(
                                                                    'event_designation_id',
                                                                    $eventDesignation->id,
                                                                )
                                                                ->pluck('name')
                                                                ->toArray() ?? '';
                                                    @endphp
                                                    @if (!empty($eventSessionUserNames))
                                                        <h6 class='lsp-1' style='color: #ffffff;'>
                                                            {{ $eventDesignation->designation }}:
                                                            @foreach ($eventSessionUserNames as $key => $eventSessionUserName)
                                                                <a href='javascript:;'
                                                                    class=''>{{ $eventSessionUserName }}</a>
                                                                @if ($key < count($eventSessionUserNames) - 1)
                                                                    ,
                                                                @endif
                                                            @endforeach
                                                        </h6>
                                                    @endif
                                                @endforeach
                                                @php
                                                    $facultyNames = null;
                                                    $facultyNames =
                                                        $eventSession->eventSessionFaculties
                                                            ->pluck('name')
                                                            ->toArray() ?? '';
                                                @endphp
                                                @if (!empty($facultyNames))
                                                    <h6 class='lsp-1' style="color: {{ $eventSession->text_color ?? '#ffffff' }};">Faculty:
                                                        @foreach ($facultyNames as $key => $facultyName)
                                                            <a href='javascript:;'
                                                                class=''>{{ $facultyName }}</a>
                                                            @if ($key < count($facultyNames) - 1)
                                                                ,
                                                            @endif
                                                        @endforeach
                                                    </h6>
                                                @endif
                                                @if ($eventSession->eventHall)
                                                    <h6 style="color: {{ $eventSession->text_color ?? '#ffffff' }};">Hall:
                                                        {{ $eventSession->eventHall->name }}
                                                    </h6>
                                                @endif
                                                <h6 style="color: {{ $eventSession->text_color ?? '#ffffff' }};">
                                                    Time:
                                                    {{ getFormattedDates($eventSession->start_time, 'h:i A') }}-
                                                    {{ getFormattedDates($eventSession->end_time, 'h:i A') }}</h6>
                                            </th>
                                        </tr>
                                        <tr style="background-color: #ffffff; color:#000000">
                                            <th scope="col">Time</th>
                                            <th scope="col" style="width: 400px;">Topic</th>
                                            <th scope="col">Speaker</th>
                                            <th scope="col">Chairperson / Panelists / Faculty</th>
                                        </tr>
                                    </thead>
                                    @foreach ($eventSession->subSessions as $subSession)
                                        @php
                                            $eventSessionAllUsers = [];
                                        @endphp

                                        @php
                                            $facultyNames = null;
                                            $facultyNames = $subSession->eventSessionFaculties->pluck('name')->toArray() ?? '';
                                            $speakerNames = null;
                                            $speakerNames = $subSession->eventSessionSpeakers->pluck('name')->toArray() ?? '';
                                        @endphp
                                        @if (!empty($facultyNames))
                                            @php
                                                $eventSessionAllUsers = array_merge(
                                                    $eventSessionAllUsers,
                                                    $facultyNames,
                                                );
                                            @endphp
                                        @endif

                                        @foreach ($event->eventDesignations as $eventDesignation)
                                            @php
                                                $eventSessionUserNames = $subSession
                                                    ->eventSessionUsers()
                                                    ->wherePivot('event_designation_id', $eventDesignation->id)
                                                    ->pluck('name')
                                                    ->toArray();
                                            @endphp

                                            @if (!empty($eventSessionUserNames))
                                                @php
                                                    $eventSessionAllUsers = array_merge(
                                                        $eventSessionAllUsers,
                                                        $eventSessionUserNames,
                                                    );
                                                @endphp
                                            @endif
                                        @endforeach

                                        {{-- @dd($eventSessionAllUsers); --}}
                                        <tbody>
                                            <tr id='Row_414'>
                                                <td style='background: #ffffff; color: #000000;'>
                                                    {{ getFormattedDates($subSession->start_time, 'h:i A') }}-
                                                    {{ getFormattedDates($subSession->end_time, 'h:i A') }}
                                                </td>
                                                <td style='background: #ffffff; color: #000000;'>
                                                    {{ $subSession->topic ?? '-' }}
                                                </td>
                                                @if (!empty($speakerNames))
                                                    <td style='background: #ffffff; color: #000000;'>
                                                        @foreach ($speakerNames as $key => $speaker)
                                                            <a
                                                                href='javascript:;'>{{ $speaker ?? '' }}</a>
                                                            @if ($key < count($speakerNames) - 1)
                                                                |
                                                            @endif
                                                        @endforeach
                                                    </td>
                                                @else
                                                    <td>-</td>
                                                @endif
                                                @if (!empty($eventSessionAllUsers))
                                                    <td style='background: #ffffff; color: #000000;'>
                                                        @foreach ($eventSessionAllUsers as $key => $eventSessionAllUsersName)
                                                            <a
                                                                href='javascript:;'>{{ $eventSessionAllUsersName ?? '' }}</a>
                                                            @if ($key < count($eventSessionAllUsers) - 1)
                                                                |
                                                            @endif
                                                        @endforeach
                                                    </td>
                                                @else
                                                    <td>-</td>
                                                @endif

                                                {{-- @foreach ($event->eventDesignations as $eventDesignation)
                                                <td style='background: #ffffff; color: #000000;'>
                                                    oooo
                                                </td>
                                            @endforeach --}}
                                            </tr>
                                        </tbody>
                                    @endforeach
                                @endforeach
                            </table>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </section>
    </div>


    <script src="{{ asset('assets/frontend/event/js/jquery.min.js') }}"></script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.nav-link').on('click', function() {
                $('.nav-link').removeClass('active show');
                $('.tab-pane').removeClass('active show');
                $(this).addClass('active show');
                var target = $(this).attr('href');
                $(target).addClass('active show');
            });
        });
    </script>

</body>

</html>
