@extends('frontend.event.registration.layout')
@section('css')
    <style>
        body {
            background-color: #d1d1d1;
        }

        h1 {
            font-size: 75px;
            color: #0b0b0b;
        }

        .bni-button {
            background-color: #df0016;
            color: #FFFFFF;
        }
    </style>
@endsection
@section('content')
    @include('includes.message')
    <div class="container p-5 text-center">
        <div class="row">
            <h3>Please check the below information and pay</h3>
        </div>

        <div class="row mt-3">
            <h3>Name: {{ $name }}</h3>
        </div>

        <div class="row mt-1">
            <h3>Mobile: {{ $contact }}</h3>
        </div>

        <div class="row mt-1">
            <h3>Email: {{ $email }}</h3>
        </div>

        <div class="row mt-1">
            <h3>Total Amount: ₹{{ $eventRegistrationFee }}</h3>
        </div>

        <div class="row mt-4">
            <div class="col-md-4"></div>
            <button id="rzp-button1" class="btn bni-button col-md-4">Pay</button>
            <div class="col-md-4"></div>
        </div>
    </div>
@endsection
@section('pageJS')
    @include('frontend.event.registration.includes.event_js')
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script src="https://js.stripe.com/v3/"></script>

    <script>
        const paymentMode = "{!! $event->eventPaymentMode->name !!}"
        console.log(paymentMode);
        if (paymentMode === "razorpay") {
            razorpay_setup();
        } else {
            instamojo_setup();
        }

        function instamojo_setup() {
            const paymentURL = "{!! $payment_link !!}";
            document.getElementById('rzp-button1').onclick = function(e){
                e.preventDefault();
                window.location.href = paymentURL;
            }
        }

        function razorpay_setup() {
            var orderId = "{!! $order_id !!}";
            var name = "{!! $name !!}";
            var email = "{!! $email !!}";
            var contact = "{!! $contact !!}";

            console.log(orderId);

            var options = {
                "key": "{!! $razorpay_api_key !!}", // Enter the Key ID generated from the Dashboard
                "amount": "{!! $eventRegistrationFee * 100 !!}", // Amount is in currency subunits. Default currency is INR. Hence, 50000 refers to 50000 paise
                "currency": "INR",
                "image": "https://mygrid.club/grid_logo.png",
                "order_id": orderId,
                "callback_url" : "{!! $callback_link !!}",
                "prefill": {
                    "name": name,
                    "email": email,
                    "contact": contact
                },
                "theme": {
                    "color": "#3399cc"
                }
            };
            console.log(options);

            var rzp1 = new Razorpay(options);
            rzp1.on('payment.failed', function (response){
                alert(response.error.description);
            });

            document.getElementById('rzp-button1').onclick = function(e){
                rzp1.open();
                e.preventDefault();
            }
        }
    </script>
@endsection