<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
<script>
    $(document).ready(function () {
        function toggleAccompanyPerson() {
            let selectedValue = $('select[name="register_accompany"]').val();
            if (selectedValue === 'Yes') {
                $('#accompany_person_wrapper').show();
                $('[name="accompany_person"]')
                    .attr('required', true)
                    .attr('data-parsley-required-message', 'Please select Accompany person.');
            } else {
                $('#accompany_person_wrapper').hide();
                $('#accompany_inputs_container').empty();
                $('select[name="accompany_person"]').val('').trigger('change');
                $('[name="accompany_person"]').removeAttr('required data-parsley-required-message');
            }
        }

        // Initial toggle on page load
        toggleAccompanyPerson();
        
        // On change
        $('select[name="register_accompany"]').on('change', function () {
            toggleAccompanyPerson();
        });

        function togglePaymentDetails() {
            const $errorMsg = $('#transaction-error');
            const $submitButton = $('#submit-btn');
            let selectedValue = $('select[name="payment_mode"]').val();
            if (selectedValue == 'Offline Registration') {
                $('#bank_details_wrapper').show();
                $('#transaction_id_wrapper').show();
                $('#transaction_date_wrapper').show();
                $('#upload_payment_receipt_wrapper').show();

                $('[name="transaction_id"]')
                    .attr('required', true)
                    .attr('data-parsley-required-message', 'Please enter transaction ID.');

                $('[name="transaction_date"]')
                    .attr('required', true)
                    .attr('data-parsley-required-message', 'Please select transaction date.');

                $('[name="upload_payment_receipt"]')
                    .attr('required', true)
                    .attr('data-parsley-required-message', 'Please upload payment receipt.');

            } else {
                $('#bank_details_wrapper').hide();
                $('#transaction_id_wrapper').hide();
                $('#transaction_date_wrapper').hide();
                $('#upload_payment_receipt_wrapper').hide();

                // Remove required validation
                $('[name="transaction_id"]').removeAttr('required data-parsley-required-message');
                $('[name="transaction_date"]').removeAttr('required data-parsley-required-message');
                $('[name="upload_payment_receipt"]').removeAttr('required data-parsley-required-message');

                $('[name="transaction_id"]').val('');
                $errorMsg.hide();
                $submitButton.prop('disabled', false);

                $('#qrcode').empty();
            }
            updateTotalAmount();
        }

        $('select[name="payment_mode"]').on('change', function () {
            togglePaymentDetails();
        });

        function generateInputs(count) {
            $('#accompany_inputs_container').show();
            let container = $('#accompany_inputs_container');
            container.empty(); // Clear previous inputs

            for (let i = 1; i <= count; i++) {
                container.append(`
                    <div class="col-md-6">
                        <div class="form-group mb-2">
                            <label for="accompany_name_${i}">Accompany Person ${i} Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="accompany_name[]" id="accompany_name_${i}" placeholder="Enter name" required>
                        </div>
                    </div>
                `);
            }
        }

        // Change listener for how many people
        $('select[name="accompany_person"]').on('change', function () {
            let count = parseInt($(this).val());
            if (!isNaN(count) && count > 0 && count <= 3) {
                generateInputs(count);
            } else {
                $('#accompany_inputs_container').empty();
                $('#accompany_inputs_container').hide();
            }
        });

        //get total amount based on selected category & workshop
        function updateTotalAmount() {
            let categoryId = $('select[name="category"]').val();
            let workshopId = $('select[name="workshop"]').val();
            let accompanyCount = parseInt($('select[name="accompany_person"]').val()) || 0;
            let paymentMode = $('select[name="payment_mode"]').val();
            let upi_id = '{{ $eventUpiDetails->upi_id ?? '' }}';
            let payee_name = '{{ $eventUpiDetails->payee_name ?? '' }}';

            $.ajax({
                url: '{{ route("frontend.get.total.amount", ["event" => $event->id]) }}',
                method: 'GET',
                data: {
                    category_id: categoryId,
                    workshop_id: workshopId,
                    accompany_person: accompanyCount
                },
                success: function (response) {
                    if (response.status) {
                        let totalAmount = response.amount;

                        $('#final-amount').text(response.amount);
                        $('#total_amount').val(response.amount);

                        if (paymentMode === 'Offline Registration') {
                            // UPI Details
                            const upiId = upi_id;
                            const payeeName = payee_name;
                            const currency = "INR";

                            // Generate Transaction ID
                            const transactionId = 'TXN' + new Date().getTime() + Math.floor(Math.random() * 1000);

                            // Construct UPI URL
                            const fallbackUrl = `upi://pay?pa=${encodeURIComponent(upiId)}&pn=${encodeURIComponent(payeeName)}&am=${encodeURIComponent(totalAmount)}&cu=${encodeURIComponent(currency)}&tid=${transactionId}`;
                            // const paytmUrl = `paytmmp://pay?pa=${encodeURIComponent(upiId)}&pn=${encodeURIComponent(payeeName)}&am=${encodeURIComponent(totalAmount)}&cu=${encodeURIComponent(currency)}&tid=${transactionId}`;

                            // Clear previous QR
                            $('#qrcode').empty();

                            // Generate QR Code
                            new QRCode(document.getElementById("qrcode"), {
                                text: fallbackUrl,
                                width: 150,
                                height: 150
                            });
                        } else {
                            $('#qrcode').empty(); // Clear if not Offline
                        }
                    } else {
                        $('#final-amount').text('0');
                        console.log(response.message);
                    }
                },
                error: function () {
                    $('#final-amount').text('0');
                    $('#qrcode').empty();
                    console.log('Error fetching amount.');
                }
            });
        }

        $('select[name="category"], select[name="workshop"], select[name="accompany_person"]').on('change', updateTotalAmount);

        //get state
        $('.country').on('change', function () {
            var selectedOption = $(this).find('option:selected');
            var countryId = selectedOption.data('countryid');
            if (countryId) {
                $.ajax({
                    url: "{{ route('frontend.get.states', ':countryId') }}".replace(':countryId', countryId),
                    type: 'GET',
                    dataType: 'json',
                    success: function (response) {
                        var $stateSelect = $('.state');
                        $stateSelect.empty().append('<option value="">-- Select State --</option>');

                        $.each(response, function (index, state) {
                            $stateSelect.append('<option value="' + state.name + '" data-stateid="' + state.id + '">' + state.name + '</option>');
                        });

                        $stateSelect.trigger('change');
                    },
                    error: function () {
                        console.log('Failed to fetch states. Please try again.');
                    }
                });
            } else {
                $('.state').empty().append('<option value="">-- Select State --</option>');
            }
        });

        var preSelectedCountryOption = $('.country option:selected');
        var preSelectedCountryId = preSelectedCountryOption.data('countryid');

        if (preSelectedCountryId) {
            $('.country').trigger('change'); // reuses the above logic
        }

        //get city
        $('.state').on('change', function () {
            var selectedOption = $(this).find('option:selected');
            var stateId = selectedOption.data('stateid');
            if (stateId) {
                $.ajax({
                    url: "{{ route('frontend.get.cities', ':stateId') }}".replace(':stateId', stateId),
                    type: 'GET',
                    dataType: 'json',
                    success: function (response) {
                        var $citySelect = $('.city');
                        $citySelect.empty().append('<option value="">-- Select City --</option>');

                        $.each(response, function (index, city) {
                            $citySelect.append('<option value="' + city.name + '" data-cityid="' + city.id + '">' + city.name + '</option>');
                        });

                        $citySelect.trigger('change');
                    },
                    error: function () {
                        console.log('Failed to fetch cities. Please try again.');
                    }
                });
            } else {
                $('.city').empty().append('<option value="">-- Select City --</option>');
            }
        });

        $('#event-registration-form').on('submit', function (e) {
            e.preventDefault();

            const $submitButton = $(this).find('button[type="submit"]');
            $submitButton.prop('disabled', true).text('Processing...');

            let formData = new FormData(this);
              $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: "{{ route('frontend.dynamic.events.register', $event->code) }}",
                data: formData,
                processData: false,
                contentType: false,
                success: function (response) {
                    if (response.payment_mode == 'razorpay') {
                        launchRazorpay(response);
                    } else {
                        window.location.href = response.payment_link;
                    }
                },
                error: function (xhr) {
                    alert('Something went wrong');
                    $submitButton.prop('disabled', false).text('Register');
                }
            });
        });

        function launchRazorpay(data) {
            const options = {
                "key": data.api_key,
                "amount": data.amount * 100,
                "currency": "INR",
                "order_id": data.order_id,
                "name": data.name,
                "email": data.email,
                "contact": data.contact,
                "callback_url": data.callback_url,
                "theme": {
                    "color": "#3399cc"
                }
            };

            const rzp = new Razorpay(options);
            rzp.open();
        }

        $('input[name="email"]').on('change', function () {
            var email = $(this).val();
            const $errorMsg = $('#email-error');
            const $submitButton = $('#submit-btn');

            if (!email) return;

            $.ajax({
                url: '{{ route("frontend.check.mail.exists", ["event" => $event->id]) }}',
                type: 'GET',
                data: {
                    email: email,
                },
                success: function (response) {
                    if (response.exists) {
                        $errorMsg.show();
                        $submitButton.prop('disabled', true);
                    } else {
                        $errorMsg.hide();
                        $submitButton.prop('disabled', false);
                    }
                },
                error: function (xhr) {
                    console.error('AJAX error:', xhr.responseText);
                }
            });
        });

        $('input[name="transaction_id"]').on('change', function () {
            var transactionId = $(this).val();
            const $errorMsg = $('#transaction-error');
            const $submitButton = $('#submit-btn');

            if (!transactionId) return;

            $.ajax({
                url: '{{ route("frontend.check.transaction.exists", ["event" => $event->id]) }}',
                type: 'GET',
                data: {
                    transactionId: transactionId,
                },
                success: function (response) {
                    if (response.exists) {
                        $errorMsg.show();
                        $submitButton.prop('disabled', true);
                    } else {
                        $errorMsg.hide();
                        $submitButton.prop('disabled', false);
                    }
                },
                error: function (xhr) {
                    console.error('AJAX error:', xhr.responseText);
                }
            });
        });
    });
</script>