@extends('frontend.event.registration.layout')

@section('css')
    <style>
        .thanks-div h1 {
            font-weight: 700;
            Size: 80px;
            color: #161616 !important;
            margin-bottom: 20px;
        }

        .thanks-div h3 {
            color: #161616 !important;
            text-align: center;
            font-size: 27px;
            font-style: normal;
            font-weight: 400;
            margin-bottom: 20px;
        }

        body {
            background-color: #FFFFFF !important;
            color: #161616 !important;
        }

        .challenge-box {
            background: #33BAFF;
            padding: 14px 14px 10px;
            max-width: 552px;
            border-radius: 15px;
            margin: 60px auto;
        }

        .challenge-box h4 {
            font-size: 14px;
            font-weight: 700;
            color: #FFFFFF;
            margin-bottom: 1px;
        }

        .challenge-box p {
            font-size: 14px;
            font-weight: 400;
            color: #FFFFFF;
            margin-bottom: 0;
        }

        .chat-btn {
            font-size: 10px !important;
            font-weight: 400 !important;
            color: #FFFFFF !important;
            line-height: 13px !important;
            margin-bottom: 0 !important;
            background: #0C4D7B !important;
            margin-top: 5px;
            border-radius: 20px !important;
            padding: 7px 60px 9px !important;
        }

        .success-img {
            max-width: 131px;
            margin-bottom: 17px;
            height: 131px;
            widows: 100%;
            object-fit: cover;
        }

        .app-play-store img {
            width: 100%;
            max-width: 268px;
            max-height: 68px;
            object-fit: contain;
        }

        .app-play-store {
            justify-content: center;
            gap: 10px
        }

        @media (max-width: 575.99px) {
            .challenge-box {
                margin: 20px auto;
            }

            .thanks-div h3 {
                font-size: 16px;
            }
        }

        p {
            font-size: 16px;
            color: #333;
        }

        .details {
            margin: 20px 0;
            padding: 15px;
            background-color: #f1f1f1;
            border-radius: 6px;
        }

        .contact {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px solid #ddd;
        }

        .container {
            max-width: 650px;
            background: #ffffff;
            margin: auto;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        @media only screen and (max-device-width: 768px) {
            .btn.btn-sm {
                font-size: 16px !important;
            }
        }
    </style>
@endsection

@section('content')
    <div class="container p-sm-5 p-2 text-center thanks-div" id="thanks-div">
        <div class="container p-3">
            <h3>✅ Thank You for Registering for {{ $event->title ?? '' }} !</h3>
            <p>We have received your registration details and offline payment information.</p>
            <p>⏳ <i>Please note:</i> Offline payments (via bank transfer or UPI) will be <strong>reviewed by the
                    Organising Committee within 2–3 working days.</strong>
                Once verified, you will receive a <strong>confirmation email along with your registration
                    number.</strong></p>
            <p>We appreciate your patience during this process.</p>
            <p><strong>Here are your submitted details:</strong></p>

            <div class="details">
                <p><strong>Name:</strong> {{ $user->name ?? '' }}</p>
                <p><strong>Mobile Number:</strong> {{ $user->contact ?? '' }}</p>
                <p><strong>Email ID:</strong> {{ $user->email ?? '' }}</p>
            </div>

            <p>📩 A confirmation message has been sent to your WhatsApp and email.</p>
            <p class="note"><strong>Note:</strong> If you don’t find the confirmation email in your inbox, please
                check
                your <strong>Spam</strong>, <strong>Promotions</strong>, or <strong>Other</strong> folders.</p>

            <div class="contact">
                <p>📞 <strong>Need Help?</strong><br>
                    If you haven’t received any confirmation on WhatsApp or email, please contact:<br>
                    <strong>{{ $event->eventManager->admin->name ?? '' }}</strong> –
                    <strong>{{ $event->eventManager->admin->full_mobile_number ?? '' }}</strong>
                </p>
            </div>
            <p class="mb-3">We look forward to seeing you at the conference!</p>
            <a href="{{ route('frontend.dynamic.events', $event->code) }}">
                <button class="mx-auto text-center btn btn-warning btn-sm">Register Another Participant</button>
            </a>
        </div>
    </div>
@endsection

@section('pageJS')
    <script>
        $(document).ready(function() {
            $('html, body').animate({
                scrollTop: $('#thanks-div').offset().top
            }, 400);
        });
    </script>
@endsection
