@once
    <!-- Load only once -->

    <!-- Quill Styles -->
    <link href="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.snow.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/styles/atom-one-dark.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/katex@0.16.9/dist/katex.min.css" />

    <!-- Google Fonts -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Roboto&family=Open+Sans&family=Lato&family=Montserrat&family=Poppins&family=Noto+Sans&family=Merriweather&family=Oswald&family=Raleway&family=Nunito&family=Ubuntu&family=PT+Serif&family=Playfair+Display&family=Inconsolata&family=Fira+Sans&family=Courier+Prime&display=swap">

    <!-- ✅ Scripts (Correct Order!) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/highlight.min.js"></script> <!-- FIRST -->
    <script src="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.js"></script> <!-- THEN Quill -->
    <script src="https://cdn.jsdelivr.net/npm/katex@0.16.9/dist/katex.min.js"></script>

    <style id="custom-font-styles"></style>
    <style>
        .ql-font.ql-picker {
            width: 200px;
        }

        .ql-snow .ql-picker.ql-font {
            width: 180px;
        }
    </style>
@endonce


@php
    $inputName = $name ?? 'content';
    $inputId = 'quill_' . $inputName;
    $fonts = [
        'Roboto',
        'Open Sans',
        'Lato',
        'Montserrat',
        'Poppins',
        'Noto Sans',
        'Merriweather',
        'Oswald',
        'Raleway',
        'Nunito',
        'Ubuntu',
        'PT Serif',
        'Playfair Display',
        'Inconsolata',
        'Fira Sans',
        'Courier Prime',
        'Arial',
        'Georgia',
        'Times New Roman',
    ];
@endphp

<div>
    <!-- Hidden input to store content -->
    <input type="hidden" name="{{ $inputName }}" id="{{ $inputId }}_input" value="{{ $value ?? '' }}">

    <!-- Quill toolbar -->
    <div id="{{ $inputId }}_toolbar">
        <span class="ql-formats">
            <select class="ql-font"></select>
            <select class="ql-size"></select>
        </span>
        <span class="ql-formats">
            <button class="ql-bold"></button>
            <button class="ql-italic"></button>
            <button class="ql-underline"></button>
            <button class="ql-strike"></button>
        </span>
        <span class="ql-formats">
            <select class="ql-color"></select>
            <select class="ql-background"></select>
        </span>
        <span class="ql-formats">
            <button class="ql-script" value="sub"></button>
            <button class="ql-script" value="super"></button>
        </span>
        <span class="ql-formats">
            <button class="ql-header" value="1"></button>
            <button class="ql-header" value="2"></button>
            <button class="ql-blockquote"></button>
            <button class="ql-code-block"></button>
        </span>
        <span class="ql-formats">
            <button class="ql-list" value="ordered"></button>
            <button class="ql-list" value="bullet"></button>
            <button class="ql-indent" value="-1"></button>
            <button class="ql-indent" value="+1"></button>
        </span>
        <span class="ql-formats">
            <button class="ql-direction" value="rtl"></button>
            <select class="ql-align"></select>
        </span>
        <span class="ql-formats">
            <button class="ql-link"></button>
            <button class="ql-image"></button>
            <button class="ql-video"></button>
            <button class="ql-formula"></button>
        </span>
        <span class="ql-formats">
            <button id="undoBtn" type="button" title="Undo">&#8630;</button>
            <button id="redoBtn" type="button" title="Redo">&#8631;</button>
            <button class="ql-clean"></button>
        </span>

    </div>

    <!-- Editor -->
    <div id="{{ $inputId }}" style="height: 300px;">{!! $value ?? '' !!}</div>
</div>

@push('js')
    <script>
        const fonts = @json($fonts);
        const fontOptions = fonts.map(f => {
            const key = f.toLowerCase().replace(/\s+/g, '');
            return `<option value="${key}">${f}</option>`;
        }).join('');
        document.querySelector('#{{ $inputId }}_toolbar .ql-font').innerHTML = fontOptions;

        const fontCSS = fonts.map(f => {
            const className = f.toLowerCase().replace(/\s+/g, '');
            return `.ql-font-${className} { font-family: '${f}', sans-serif; }`;
        }).join('\n');
        document.getElementById('custom-font-styles').textContent += fontCSS;

        // Undo button
        document.getElementById('undoBtn').addEventListener('click', () => {
            quill_{{ $inputName }}.history.undo();
        });

        // Redo button
        document.getElementById('redoBtn').addEventListener('click', () => {
            quill_{{ $inputName }}.history.redo();
        });


        const Font = Quill.import('formats/font');
        Font.whitelist = fonts.map(f => f.toLowerCase().replace(/\s+/g, ''));
        Quill.register(Font, true);

        const quill_{{ $inputName }} = new Quill('#{{ $inputId }}', {
            theme: 'snow',
            modules: {
                history: {
                    delay: 1000, // Group changes within 1 second
                    maxStack: 100, // Keep up to 100 undo steps
                    userOnly: true, // Track only user input, ignore API changes
                },
                syntax: true,
                toolbar: '#{{ $inputId }}_toolbar'

            },
            placeholder: 'Write something amazing...'
        });


        // Sync content to hidden input
        quill_{{ $inputName }}.on('text-change', function () {
            document.getElementById('{{ $inputId }}_input').value = quill_{{ $inputName }}.root.innerHTML;
        });

        // If initial value exists
        quill_{{ $inputName }}.root.innerHTML = `{!! addslashes($value ?? '') !!}`;
    </script>
@endpush