<div class="sidebar-inner">

    <a href="{{ route('event.home') }}" class="sidenav-logo">
        <img class="img-fluid" src="{{ asset('assets/images/logo.png') }}">
    </a>

    <!-- Sidebar menu -->
    <ul class="sidenav-menu">
        <li class="menu-item">
            <a href="{{ route('event.home') }}" class="menu-link @if (Route::currentRouteName() == 'home') active @endif"
                title="Home">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M17.85 6.77777C17.85 6.2087 17.8507 5.799 17.8782 5.47883C17.9062 5.15184 17.9555 5.03188 17.9789 4.99287C17.9849 4.9828 17.9873 4.98107 17.9905 4.97876L17.991 4.97841C17.9974 4.97365 18.0249 4.95519 18.0944 4.93372C18.2503 4.88561 18.5213 4.84999 19 4.84999C19.4788 4.84999 19.7497 4.88561 19.9056 4.93372C19.9752 4.95519 20.0026 4.97365 20.0091 4.97841L20.0096 4.97876C20.0127 4.98107 20.0151 4.9828 20.0212 4.99287C20.0446 5.03188 20.0939 5.15184 20.1219 5.47883C20.1493 5.799 20.15 6.2087 20.15 6.77777V6.79084V6.80399V6.81722V6.83054V6.84395V6.85744V6.87102V6.88468V6.89842V6.91225V6.92616V6.94015V6.95422V6.96838V6.98262V6.99694V7.01134V7.02583V7.04039V7.05503V7.06975V7.08455V7.09944V7.1144V7.12943V7.14455V7.15974V7.17501V7.19036V7.20579V7.22129V7.23686V7.25252V7.26824V7.28405V7.29992V7.31588V7.3319V7.348V7.36417V7.38042V7.39674V7.41313V7.42959V7.44613V7.46273V7.47941V7.49615V7.51297V7.52986V7.54682V7.56384V7.58094V7.5981V7.61533V7.63263V7.65V7.66743V7.68493V7.7025V7.72014V7.73783V7.7556V7.77343V7.79133V7.80929V7.82731V7.8454V7.86355V7.88176V7.90004V7.91838V7.93678V7.95525V7.97377V7.99236V8.01101V8.02971V8.04848V8.06731V8.0862V8.10514V8.12415V8.14321V8.16233V8.18151V8.20075V8.22004V8.23939V8.2588V8.27826V8.29778V8.31735V8.33698V8.35667V8.3764V8.3962V8.41604V8.43594V8.45589V8.4759V8.49596V8.51607V8.53623V8.55644V8.5767V8.59702V8.61738V8.63779V8.65826V8.67877V8.69933V8.71994V8.7406V8.76131V8.78207V8.80287V8.82372V8.84461V8.86555V8.88654V8.90758V8.92865V8.94978V8.97095V8.99216V9.01342V9.03472V9.05606V9.07744V9.09887V9.12034V9.14186V9.16341V9.18501V9.20664V9.22832V9.25004V9.27179V9.29359V9.31543V9.3373V9.35921V9.38116V9.40315V9.42518V9.44724V9.46934V9.49148V9.51365V9.53586V9.55811V9.58039V9.6027V9.62505V9.64743V9.66985V9.6923V9.71478V9.7373V9.75985V9.78243V9.80504V9.82768V9.85036V9.87306V9.8958V9.91856V9.94136V9.96418V9.98704V10.0099V10.0328V10.0558V10.0787V10.1017V10.1248V10.1478V10.1709V10.194V10.2171V10.2403V10.2634V10.2866V10.3099V10.3331V10.3564V10.3797V10.403V10.4263V10.4497V10.4731V10.4965V10.5199V10.5434V10.5668V10.5903V10.6138V10.6374V10.6609V10.6845V10.7081V10.7317V10.7553V10.7789V10.8026V10.8263V10.85V10.8737V10.8974V10.9211V10.9449V10.9687V10.9924V11.0162V11.0401V11.0639V11.0877V11.1116V11.1354V11.1593V11.1832V11.2071V11.231V11.2549V11.2789V11.3028V11.3267V11.3507V11.3747V11.3987V11.4226V11.4466V11.4706V11.4947V11.5187V11.5427V11.5667V11.5908V11.6148V11.6389V11.6629V11.687V11.711V11.7351V11.7592V11.7832V11.8073V11.8314V11.8555V11.8796V11.9036V11.9277V11.9518V11.9759V12V12.0241V12.0482V12.0723V12.0963V12.1204V12.1445V12.1686V12.1927V12.2167V12.2408V12.2649V12.289V12.313V12.3371V12.3611V12.3852V12.4092V12.4333V12.4573V12.4813V12.5053V12.5293V12.5533V12.5773V12.6013V12.6253V12.6493V12.6732V12.6972V12.7211V12.7451V12.769V12.7929V12.8168V12.8407V12.8646V12.8884V12.9123V12.9361V12.9599V12.9837V13.0075V13.0313V13.0551V13.0788V13.1026V13.1263V13.15V13.1737V13.1974V13.221V13.2447V13.2683V13.2919V13.3155V13.3391V13.3626V13.3861V13.4097V13.4331V13.4566V13.4801V13.5035V13.5269V13.5503V13.5737V13.597V13.6203V13.6436V13.6669V13.6901V13.7134V13.7366V13.7597V13.7829V13.806V13.8291V13.8522V13.8752V13.8983V13.9212V13.9442V13.9672V13.9901V14.0129V14.0358V14.0586V14.0814V14.1042V14.1269V14.1496V14.1723V14.1949V14.2176V14.2401V14.2627V14.2852V14.3077V14.3301V14.3526V14.3749V14.3973V14.4196V14.4419V14.4641V14.4863V14.5085V14.5306V14.5527V14.5748V14.5968V14.6188V14.6408V14.6627V14.6846V14.7064V14.7282V14.7499V14.7717V14.7933V14.815V14.8366V14.8581V14.8796V14.9011V14.9225V14.9439V14.9653V14.9866V15.0078V15.029V15.0502V15.0713V15.0924V15.1134V15.1344V15.1554V15.1763V15.1971V15.2179V15.2387V15.2594V15.28V15.3007V15.3212V15.3417V15.3622V15.3826V15.403V15.4233V15.4435V15.4638V15.4839V15.504V15.5241V15.5441V15.564V15.5839V15.6038V15.6236V15.6433V15.663V15.6826V15.7022V15.7217V15.7412V15.7606V15.7799V15.7992V15.8185V15.8377V15.8568V15.8758V15.8948V15.9138V15.9327V15.9515V15.9703V15.989V16.0076V16.0262V16.0447V16.0632V16.0816V16.0999V16.1182V16.1364V16.1546V16.1727V16.1907V16.2087V16.2266V16.2444V16.2621V16.2799V16.2975V16.3151V16.3326V16.35V16.3674V16.3847V16.4019V16.419V16.4361V16.4532V16.4701V16.487V16.5038V16.5206V16.5373V16.5539V16.5704V16.5869V16.6032V16.6196V16.6358V16.652V16.6681V16.6841V16.7001V16.7159V16.7317V16.7475V16.7631V16.7787V16.7942V16.8096V16.825V16.8402V16.8554V16.8706V16.8856V16.9005V16.9154V16.9302V16.945V16.9596V16.9742V16.9886V17.003V17.0174V17.0316V17.0458V17.0598V17.0738V17.0877V17.1016V17.1153V17.129V17.1425V17.156V17.1694V17.1828V17.196V17.2092V17.2222C20.15 17.8944 20.1119 18.3497 20.049 18.6586C19.9858 18.9689 19.9123 19.0565 19.8998 19.0698C19.8953 19.0746 19.8912 19.0784 19.8782 19.0845C19.8612 19.0925 19.8241 19.1064 19.7516 19.1189C19.5859 19.1474 19.3687 19.15 19 19.15C18.6256 19.15 18.4056 19.1474 18.2388 19.1188C18.1657 19.1063 18.129 19.0924 18.113 19.0848C18.1009 19.0791 18.098 19.0761 18.0946 19.0724C18.0836 19.0606 18.0109 18.9742 17.9487 18.6621C17.8869 18.352 17.85 17.8956 17.85 17.2222V6.77777ZM19 3.14999C18.0337 3.14999 17.0408 3.25214 16.5212 4.11823C16.2946 4.49588 16.2189 4.93148 16.1844 5.33366C16.15 5.73476 16.15 6.21671 16.15 6.74641V6.74642V6.77777V17.2222C16.15 17.9377 16.1876 18.523 16.2815 18.9942C16.3749 19.4633 16.539 19.8977 16.8525 20.2332C17.1818 20.5855 17.5835 20.7313 17.9517 20.7944C18.2776 20.8502 18.6414 20.8501 18.9597 20.85L19 20.85L19.0397 20.85C19.3532 20.8501 19.7146 20.8502 20.0398 20.7943C20.4069 20.7311 20.8073 20.5856 21.137 20.2357C21.4517 19.9018 21.619 19.4686 21.7148 18.9977C21.811 18.5253 21.85 17.939 21.85 17.2222V17.2092V17.196V17.1828V17.1694V17.156V17.1425V17.129V17.1153V17.1016V17.0877V17.0738V17.0598V17.0458V17.0316V17.0174V17.003V16.9886V16.9742V16.9596V16.945V16.9302V16.9154V16.9005V16.8856V16.8706V16.8554V16.8402V16.825V16.8096V16.7942V16.7787V16.7631V16.7475V16.7317V16.7159V16.7001V16.6841V16.6681V16.652V16.6358V16.6196V16.6032V16.5869V16.5704V16.5539V16.5373V16.5206V16.5038V16.487V16.4701V16.4532V16.4361V16.419V16.4019V16.3847V16.3674V16.35V16.3326V16.3151V16.2975V16.2799V16.2621V16.2444V16.2266V16.2087V16.1907V16.1727V16.1546V16.1364V16.1182V16.0999V16.0816V16.0632V16.0447V16.0262V16.0076V15.989V15.9703V15.9515V15.9327V15.9138V15.8948V15.8758V15.8568V15.8377V15.8185V15.7992V15.7799V15.7606V15.7412V15.7217V15.7022V15.6826V15.663V15.6433V15.6236V15.6038V15.5839V15.564V15.5441V15.5241V15.504V15.4839V15.4638V15.4435V15.4233V15.403V15.3826V15.3622V15.3417V15.3212V15.3007V15.28V15.2594V15.2387V15.2179V15.1971V15.1763V15.1554V15.1344V15.1134V15.0924V15.0713V15.0502V15.029V15.0078V14.9866V14.9653V14.9439V14.9225V14.9011V14.8796V14.8581V14.8366V14.815V14.7933V14.7717V14.7499V14.7282V14.7064V14.6846V14.6627V14.6408V14.6188V14.5968V14.5748V14.5527V14.5306V14.5085V14.4863V14.4641V14.4419V14.4196V14.3973V14.3749V14.3526V14.3301V14.3077V14.2852V14.2627V14.2401V14.2176V14.1949V14.1723V14.1496V14.1269V14.1042V14.0814V14.0586V14.0358V14.0129V13.9901V13.9672V13.9442V13.9212V13.8983V13.8752V13.8522V13.8291V13.806V13.7829V13.7597V13.7366V13.7134V13.6901V13.6669V13.6436V13.6203V13.597V13.5737V13.5503V13.5269V13.5035V13.4801V13.4566V13.4331V13.4097V13.3861V13.3626V13.3391V13.3155V13.2919V13.2683V13.2447V13.221V13.1974V13.1737V13.15V13.1263V13.1026V13.0788V13.0551V13.0313V13.0075V12.9837V12.9599V12.9361V12.9123V12.8884V12.8646V12.8407V12.8168V12.7929V12.769V12.7451V12.7211V12.6972V12.6732V12.6493V12.6253V12.6013V12.5773V12.5533V12.5293V12.5053V12.4813V12.4573V12.4333V12.4092V12.3852V12.3611V12.3371V12.313V12.289V12.2649V12.2408V12.2167V12.1927V12.1686V12.1445V12.1204V12.0963V12.0723V12.0482V12.0241V12V11.9759V11.9518V11.9277V11.9036V11.8796V11.8555V11.8314V11.8073V11.7832V11.7592V11.7351V11.711V11.687V11.6629V11.6389V11.6148V11.5908V11.5667V11.5427V11.5187V11.4947V11.4706V11.4466V11.4226V11.3987V11.3747V11.3507V11.3267V11.3028V11.2789V11.2549V11.231V11.2071V11.1832V11.1593V11.1354V11.1116V11.0877V11.0639V11.0401V11.0162V10.9924V10.9687V10.9449V10.9211V10.8974V10.8737V10.85V10.8263V10.8026V10.7789V10.7553V10.7317V10.7081V10.6845V10.6609V10.6374V10.6138V10.5903V10.5668V10.5434V10.5199V10.4965V10.4731V10.4497V10.4263V10.403V10.3797V10.3564V10.3331V10.3099V10.2866V10.2634V10.2403V10.2171V10.194V10.1709V10.1478V10.1248V10.1017V10.0787V10.0558V10.0328V10.0099V9.98704V9.96418V9.94136V9.91856V9.8958V9.87306V9.85036V9.82768V9.80504V9.78243V9.75985V9.7373V9.71478V9.6923V9.66985V9.64743V9.62505V9.6027V9.58039V9.55811V9.53586V9.51365V9.49148V9.46934V9.44724V9.42518V9.40315V9.38116V9.35921V9.3373V9.31543V9.29359V9.27179V9.25004V9.22832V9.20664V9.18501V9.16341V9.14186V9.12034V9.09887V9.07744V9.05606V9.03472V9.01342V8.99216V8.97095V8.94978V8.92865V8.90758V8.88654V8.86555V8.84461V8.82372V8.80287V8.78207V8.76131V8.7406V8.71994V8.69933V8.67877V8.65826V8.63779V8.61738V8.59702V8.5767V8.55644V8.53623V8.51607V8.49596V8.4759V8.45589V8.43594V8.41604V8.3962V8.3764V8.35667V8.33698V8.31735V8.29778V8.27826V8.2588V8.23939V8.22004V8.20075V8.18151V8.16233V8.14321V8.12415V8.10514V8.0862V8.06731V8.04848V8.02971V8.01101V7.99236V7.97377V7.95525V7.93678V7.91838V7.90004V7.88176V7.86355V7.8454V7.82731V7.80929V7.79133V7.77343V7.7556V7.73783V7.72014V7.7025V7.68493V7.66743V7.65V7.63263V7.61533V7.5981V7.58094V7.56384V7.54682V7.52986V7.51297V7.49615V7.47941V7.46273V7.44613V7.42959V7.41313V7.39674V7.38042V7.36417V7.348V7.3319V7.31588V7.29992V7.28405V7.26824V7.25252V7.23686V7.22129V7.20579V7.19036V7.17501V7.15974V7.14455V7.12943V7.1144V7.09944V7.08455V7.06975V7.05503V7.04039V7.02583V7.01134V6.99694V6.98262V6.96838V6.95422V6.94015V6.92616V6.91225V6.89842V6.88468V6.87102V6.85744V6.84395V6.83054V6.81722V6.80399V6.79084V6.77777L21.85 6.7464C21.85 6.21671 21.8501 5.73475 21.8157 5.33366C21.7812 4.93148 21.7055 4.49588 21.4789 4.11823C20.9592 3.25214 19.9663 3.14999 19 3.14999ZM10.879 9.49996C10.854 9.72539 10.853 9.98789 10.853 10.3333L10.853 14L10.853 17.6667C10.853 17.6748 10.8529 17.683 10.8527 17.6912C10.8279 18.5507 10.9843 18.8412 11.0773 18.9408C11.1577 19.0269 11.3596 19.15 11.9997 19.15C12.6255 19.15 12.8337 19.0284 12.9193 18.9376C13.0145 18.8368 13.1743 18.5457 13.1469 17.6939C13.1466 17.6848 13.1465 17.6757 13.1465 17.6667V14L13.1465 10.3333C13.1465 9.98789 13.1455 9.72539 13.1205 9.49996C13.0958 9.27778 13.054 9.1641 13.0177 9.10346L13.0165 9.1014C12.9931 9.06167 12.8682 8.84999 11.9997 8.84999C11.1313 8.84999 11.0064 9.06167 10.983 9.1014L10.9818 9.10346C10.9454 9.1641 10.9037 9.27778 10.879 9.49996ZM9.52341 8.22987C10.0024 7.43027 10.8878 7.14999 11.9997 7.14999C13.1117 7.14999 13.9971 7.43027 14.4761 8.22987C14.6894 8.58589 14.7724 8.97221 14.8101 9.31253C14.8465 9.64098 14.8465 9.99359 14.8465 10.3086L14.8465 10.3333L14.8465 14V17.6534C14.8761 18.6293 14.7263 19.4995 14.156 20.104C13.5736 20.7216 12.754 20.85 11.9997 20.85C11.2382 20.85 10.4154 20.7231 9.83455 20.1008C9.26881 19.4947 9.12652 18.6235 9.15301 17.6547L9.15301 14L9.153 10.3333L9.153 10.3086C9.15298 9.99358 9.15295 9.64098 9.18938 9.31253C9.22713 8.97221 9.31014 8.58589 9.52341 8.22987ZM3.87711 14.5196C3.85089 14.7834 3.85003 15.1018 3.85003 15.5278V18.2943C3.85003 18.7748 3.9662 18.9063 4.02252 18.9539C4.11412 19.0314 4.36207 19.15 5.00003 19.15C5.62373 19.15 5.87547 19.0327 5.97207 18.9517C6.03288 18.9007 6.15003 18.7665 6.15003 18.2943V18.2872V18.2801V18.273V18.2659V18.2589V18.2518V18.2448V18.2378V18.2308V18.2238V18.2168V18.2099V18.2029V18.196V18.1891V18.1822V18.1753V18.1684V18.1616V18.1547V18.1479V18.1411V18.1343V18.1275V18.1207V18.1139V18.1072V18.1004V18.0937V18.087V18.0803V18.0736V18.0669V18.0603V18.0536V18.047V18.0404V18.0338V18.0272V18.0206V18.014V18.0075V18.0009V17.9944V17.9879V17.9814V17.9749V17.9684V17.9619V17.9555V17.949V17.9426V17.9362V17.9298V17.9234V17.917V17.9106V17.9043V17.8979V17.8916V17.8853V17.879V17.8727V17.8664V17.8601V17.8538V17.8476V17.8413V17.8351V17.8289V17.8227V17.8165V17.8103V17.8041V17.7979V17.7918V17.7857V17.7795V17.7734V17.7673V17.7612V17.7551V17.749V17.743V17.7369V17.7309V17.7248V17.7188V17.7128V17.7068V17.7008V17.6948V17.6889V17.6829V17.6769V17.671V17.6651V17.6592V17.6532V17.6473V17.6415V17.6356V17.6297V17.6238V17.618V17.6122V17.6063V17.6005V17.5947V17.5889V17.5831V17.5773V17.5715V17.5658V17.56V17.5543V17.5485V17.5428V17.5371V17.5314V17.5257V17.52V17.5143V17.5086V17.503V17.4973V17.4917V17.486V17.4804V17.4748V17.4692V17.4636V17.458V17.4524V17.4468V17.4412V17.4357V17.4301V17.4246V17.419V17.4135V17.408V17.4025V17.397V17.3915V17.386V17.3805V17.375V17.3696V17.3641V17.3587V17.3532V17.3478V17.3424V17.3369V17.3315V17.3261V17.3207V17.3153V17.3099V17.3046V17.2992V17.2938V17.2885V17.2831V17.2778V17.2725V17.2671V17.2618V17.2565V17.2512V17.2459V17.2406V17.2353V17.23V17.2248V17.2195V17.2142V17.209V17.2037V17.1985V17.1933V17.188V17.1828V17.1776V17.1724V17.1672V17.162V17.1568V17.1516V17.1464V17.1412V17.1361V17.1309V17.1257V17.1206V17.1154V17.1103V17.1052V17.1V17.0949V17.0898V17.0847V17.0796V17.0744V17.0693V17.0643V17.0592V17.0541V17.049V17.0439V17.0389V17.0338V17.0287V17.0237V17.0186V17.0136V17.0085V17.0035V16.9985V16.9934V16.9884V16.9834V16.9784V16.9734V16.9684V16.9634V16.9584V16.9534V16.9484V16.9434V16.9384V16.9334V16.9284V16.9235V16.9185V16.9135V16.9086V16.9036V16.8987V16.8937V16.8888V16.8838V16.8789V16.874V16.869V16.8641V16.8592V16.8543V16.8493V16.8444V16.8395V16.8346V16.8297V16.8248V16.8199V16.815V16.8101V16.8052V16.8003V16.7954V16.7905V16.7856V16.7808V16.7759V16.771V16.7661V16.7613V16.7564V16.7515V16.7467V16.7418V16.7369V16.7321V16.7272V16.7224V16.7175V16.7127V16.7078V16.703V16.6981V16.6933V16.6884V16.6836V16.6787V16.6739V16.6691V16.6642V16.6594V16.6546V16.6497V16.6449V16.6401V16.6352V16.6304V16.6256V16.6208V16.6159V16.6111V16.6063V16.6015V16.5966V16.5918V16.587V16.5822V16.5774V16.5725V16.5677V16.5629V16.5581V16.5533V16.5485V16.5436V16.5388V16.534V16.5292V16.5244V16.5196V16.5147V16.5099V16.5051V16.5003V16.4955V16.4907V16.4858V16.481V16.4762V16.4714V16.4666V16.4617V16.4569V16.4521V16.4473V16.4425V16.4376V16.4328V16.428V16.4231V16.4183V16.4135V16.4087V16.4038V16.399V16.3942V16.3893V16.3845V16.3797V16.3748V16.37V16.3651V16.3603V16.3554V16.3506V16.3458V16.3409V16.3361V16.3312V16.3263V16.3215V16.3166V16.3118V16.3069V16.302V16.2972V16.2923V16.2874V16.2826V16.2777V16.2728V16.2679V16.263V16.2581V16.2533V16.2484V16.2435V16.2386V16.2337V16.2288V16.2239V16.219V16.214V16.2091V16.2042V16.1993V16.1944V16.1894V16.1845V16.1796V16.1746V16.1697V16.1648V16.1598V16.1549V16.1499V16.145V16.14V16.135V16.1301V16.1251V16.1201V16.1151V16.1102V16.1052V16.1002V16.0952V16.0902V16.0852V16.0802V16.0752V16.0701V16.0651V16.0601V16.0551V16.05V16.045V16.04V16.0349V16.0299V16.0248V16.0197V16.0147V16.0096V16.0045V15.9995V15.9944V15.9893V15.9842V15.9791V15.974V15.9689V15.9637V15.9586V15.9535V15.9484V15.9432V15.9381V15.9329V15.9278V15.9226V15.9175V15.9123V15.9071V15.9019V15.8967V15.8916V15.8864V15.8811V15.8759V15.8707V15.8655V15.8603V15.855V15.8498V15.8445V15.8393V15.834V15.8287V15.8235V15.8182V15.8129V15.8076V15.8023V15.797V15.7917V15.7864V15.781V15.7757V15.7704V15.765V15.7597V15.7543V15.7489V15.7436V15.7382V15.7328V15.7274V15.722V15.7166V15.7111V15.7057V15.7003V15.6948V15.6894V15.6839V15.6785V15.673V15.6675V15.662V15.6565V15.651V15.6455V15.64V15.6344V15.6289V15.6234V15.6178V15.6122V15.6067V15.6011V15.5955V15.5899V15.5843V15.5787V15.5731V15.5674V15.5618V15.5561V15.5505V15.5448V15.5429L6.14311 15.3406V15.3406C6.13205 15.0114 6.12341 14.754 6.09885 14.5269C6.06936 14.2543 6.02495 14.1272 5.98961 14.0653L5.98894 14.0638C5.97993 14.0437 5.89336 13.85 5.00003 13.85C4.10278 13.85 3.9983 14.0458 3.98392 14.0728L3.98282 14.0748C3.94834 14.1335 3.90328 14.2563 3.87711 14.5196ZM2.51722 13.2134C3.00748 12.3793 3.92522 12.15 5.00003 12.15C6.07679 12.15 6.98578 12.3806 7.46626 13.2229C7.67355 13.5863 7.75045 13.9879 7.78899 14.3441C7.82101 14.6402 7.83207 14.9752 7.84295 15.3046C7.84508 15.3692 7.84721 15.4336 7.84949 15.4975L7.84978 15.5072L7.85003 15.5278V15.5335V15.5391V15.5448V15.5505V15.5561V15.5618V15.5674V15.5731V15.5787V15.5843V15.5899V15.5955V15.6011V15.6067V15.6122V15.6178V15.6234V15.6289V15.6344V15.64V15.6455V15.651V15.6565V15.662V15.6675V15.673V15.6785V15.6839V15.6894V15.6948V15.7003V15.7057V15.7111V15.7166V15.722V15.7274V15.7328V15.7382V15.7436V15.7489V15.7543V15.7597V15.765V15.7704V15.7757V15.781V15.7864V15.7917V15.797V15.8023V15.8076V15.8129V15.8182V15.8235V15.8287V15.834V15.8393V15.8445V15.8498V15.855V15.8603V15.8655V15.8707V15.8759V15.8811V15.8864V15.8916V15.8967V15.9019V15.9071V15.9123V15.9175V15.9226V15.9278V15.9329V15.9381V15.9432V15.9484V15.9535V15.9586V15.9637V15.9689V15.974V15.9791V15.9842V15.9893V15.9944V15.9995V16.0045V16.0096V16.0147V16.0197V16.0248V16.0299V16.0349V16.04V16.045V16.05V16.0551V16.0601V16.0651V16.0701V16.0752V16.0802V16.0852V16.0902V16.0952V16.1002V16.1052V16.1102V16.1151V16.1201V16.1251V16.1301V16.135V16.14V16.145V16.1499V16.1549V16.1598V16.1648V16.1697V16.1746V16.1796V16.1845V16.1894V16.1944V16.1993V16.2042V16.2091V16.214V16.219V16.2239V16.2288V16.2337V16.2386V16.2435V16.2484V16.2533V16.2581V16.263V16.2679V16.2728V16.2777V16.2826V16.2874V16.2923V16.2972V16.302V16.3069V16.3118V16.3166V16.3215V16.3263V16.3312V16.3361V16.3409V16.3458V16.3506V16.3554V16.3603V16.3651V16.37V16.3748V16.3797V16.3845V16.3893V16.3942V16.399V16.4038V16.4087V16.4135V16.4183V16.4231V16.428V16.4328V16.4376V16.4425V16.4473V16.4521V16.4569V16.4617V16.4666V16.4714V16.4762V16.481V16.4858V16.4907V16.4955V16.5003V16.5051V16.5099V16.5147V16.5196V16.5244V16.5292V16.534V16.5388V16.5436V16.5485V16.5533V16.5581V16.5629V16.5677V16.5725V16.5774V16.5822V16.587V16.5918V16.5966V16.6015V16.6063V16.6111V16.6159V16.6208V16.6256V16.6304V16.6352V16.6401V16.6449V16.6497V16.6546V16.6594V16.6642V16.6691V16.6739V16.6787V16.6836V16.6884V16.6933V16.6981V16.703V16.7078V16.7127V16.7175V16.7224V16.7272V16.7321V16.7369V16.7418V16.7467V16.7515V16.7564V16.7613V16.7661V16.771V16.7759V16.7808V16.7856V16.7905V16.7954V16.8003V16.8052V16.8101V16.815V16.8199V16.8248V16.8297V16.8346V16.8395V16.8444V16.8493V16.8543V16.8592V16.8641V16.869V16.874V16.8789V16.8838V16.8888V16.8937V16.8987V16.9036V16.9086V16.9135V16.9185V16.9235V16.9284V16.9334V16.9384V16.9434V16.9484V16.9534V16.9584V16.9634V16.9684V16.9734V16.9784V16.9834V16.9884V16.9934V16.9985V17.0035V17.0085V17.0136V17.0186V17.0237V17.0287V17.0338V17.0389V17.0439V17.049V17.0541V17.0592V17.0643V17.0693V17.0744V17.0796V17.0847V17.0898V17.0949V17.1V17.1052V17.1103V17.1154V17.1206V17.1257V17.1309V17.1361V17.1412V17.1464V17.1516V17.1568V17.162V17.1672V17.1724V17.1776V17.1828V17.188V17.1933V17.1985V17.2037V17.209V17.2142V17.2195V17.2248V17.23V17.2353V17.2406V17.2459V17.2512V17.2565V17.2618V17.2671V17.2725V17.2778V17.2831V17.2885V17.2938V17.2992V17.3046V17.3099V17.3153V17.3207V17.3261V17.3315V17.3369V17.3424V17.3478V17.3532V17.3587V17.3641V17.3696V17.375V17.3805V17.386V17.3915V17.397V17.4025V17.408V17.4135V17.419V17.4246V17.4301V17.4357V17.4412V17.4468V17.4524V17.458V17.4636V17.4692V17.4748V17.4804V17.486V17.4917V17.4973V17.503V17.5086V17.5143V17.52V17.5257V17.5314V17.5371V17.5428V17.5485V17.5543V17.56V17.5658V17.5715V17.5773V17.5831V17.5889V17.5947V17.6005V17.6063V17.6122V17.618V17.6238V17.6297V17.6356V17.6415V17.6473V17.6532V17.6592V17.6651V17.671V17.6769V17.6829V17.6889V17.6948V17.7008V17.7068V17.7128V17.7188V17.7248V17.7309V17.7369V17.743V17.749V17.7551V17.7612V17.7673V17.7734V17.7795V17.7857V17.7918V17.7979V17.8041V17.8103V17.8165V17.8227V17.8289V17.8351V17.8413V17.8476V17.8538V17.8601V17.8664V17.8727V17.879V17.8853V17.8916V17.8979V17.9043V17.9106V17.917V17.9234V17.9298V17.9362V17.9426V17.949V17.9555V17.9619V17.9684V17.9749V17.9814V17.9879V17.9944V18.0009V18.0075V18.014V18.0206V18.0272V18.0338V18.0404V18.047V18.0536V18.0603V18.0669V18.0736V18.0803V18.087V18.0937V18.1004V18.1072V18.1139V18.1207V18.1275V18.1343V18.1411V18.1479V18.1547V18.1616V18.1684V18.1753V18.1822V18.1891V18.196V18.2029V18.2099V18.2168V18.2238V18.2308V18.2378V18.2448V18.2518V18.2589V18.2659V18.273V18.2801V18.2872V18.2943C7.85003 19.0374 7.65832 19.756 7.0647 20.2541C6.50686 20.722 5.75861 20.85 5.00003 20.85C4.23401 20.85 3.48196 20.7233 2.92456 20.2518C2.33186 19.7504 2.15003 19.029 2.15003 18.2943V15.5278V15.5003V15.5003C2.15001 15.1086 2.14999 14.7083 2.18544 14.3515C2.22177 13.9859 2.3017 13.5801 2.51722 13.2134Z"
                        fill="#7C8DB5" />
                </svg>
                <h4 class="headline">Home</h4>
            </a>
        </li>
        <li class="menu-item dropdown-indicator">
            <a class="menu-link 
            @if (Route::is('event.forms.categories.*') ||
                    Route::is('event.forms.slabs.*') ||
                    Route::is('event.forms.workshops.*') ||
                    Route::is('event.forms.fields.*') ||
                    Route::is('event.bank.details.*') ||
                    Route::is('event.forms.upi.details.*') ||
                    Route::is('event.payment.modes.index') ||
                    Route::is('event.config.index')) active @endif" data-bs-toggle="collapse"
                href="#eventForm" role="button"
                @if (Route::is('event.forms.categories.*') ||
                        Route::is('event.forms.slabs.*') ||
                        Route::is('event.forms.workshops.*') ||
                        Route::is('event.forms.fields.*') ||
                        Route::is('event.bank.details.*') ||
                        Route::is('event.forms.upi.details.*') ||
                        Route::is('event.payment.modes.index') ||
                        Route::is('event.config.index')) aria-expanded="true" @else aria-expanded="false" @endif
                aria-controls="eventForm" title="Sessions">
                <svg width="800px" height="800px" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M5.29289 5.29289C5 5.58579 5 6.05719 5 7V17C5 18.8856 5 19.8284 5.58579 20.4142C5.91238 20.7408 6.34994 20.8853 7 20.9493V19.5C7 18.6716 7.67157 18 8.5 18C9.32843 18 10 18.6716 10 19.5V21H14V19.5C14 18.6716 14.6716 18 15.5 18C16.3284 18 17 18.6716 17 19.5V20.9493C17.6501 20.8853 18.0876 20.7408 18.4142 20.4142C19 19.8284 19 18.8856 19 17V7C19 6.05719 19 5.58579 18.7071 5.29289C18.4142 5 17.9428 5 17 5H7C6.05719 5 5.58579 5 5.29289 5.29289Z"
                        fill="#2A4157" fill-opacity="0.24" />
                    <path d="M8.5 9.5L15.5 9.5" stroke="#222222" stroke-linecap="round" />
                    <path d="M8.5 12.5L12.5 12.5" stroke="#222222" stroke-linecap="round" />
                    <path d="M8.5 15.5L14.5 15.5" stroke="#222222" stroke-linecap="round" />
                    <path
                        d="M16 19.5C16 19.2239 15.7761 19 15.5 19C15.2239 19 15 19.2239 15 19.5H16ZM15 19.5V21H16V19.5H15Z"
                        fill="#33363F" />
                    <path d="M9 19.5C9 19.2239 8.77614 19 8.5 19C8.22386 19 8 19.2239 8 19.5H9ZM8 19.5V21H9V19.5H8Z"
                        fill="#33363F" />
                </svg>
                <h4 class="headline">Event Form</h4>
            </a>
            <ul class="sidenav-submenu collapse @if (Route::is('event.forms.categories.*') ||
                    Route::is('event.forms.slabs.*') ||
                    Route::is('event.forms.workshops.*') ||
                    Route::is('event.forms.fields.*') ||
                    Route::is('event.bank.details.*') ||
                    Route::is('event.forms.upi.details.*') ||
                    Route::is('event.payment.modes.index') ||
                    Route::is('event.config.index')) show @endif" id="eventForm">
                <li class="menu-item">
                    <a href="{{ route('event.forms.categories.index') }}"
                        class="menu-link @if (Route::is('event.forms.categories.*')) active @endif">
                        <h4 class="headline">Categories</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.forms.slabs.index') }}"
                        class="menu-link @if (Route::is('event.forms.slabs.*')) active @endif">
                        <h4 class="headline">Slabs</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.forms.workshops.index') }}"
                        class="menu-link @if (Route::is('event.forms.workshops.*')) active @endif">
                        <h4 class="headline">Workshops</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.forms.fields.index') }}"
                        class="menu-link @if (Route::is('event.forms.fields.*')) active @endif">
                        <h4 class="headline">Fields</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.bank.details.index') }}"
                        class="menu-link @if (Route::is('event.bank.details.*')) active @endif">
                        <h4 class="headline">Bank Details</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.forms.upi.details.index') }}"
                        class="menu-link @if (Route::is('event.forms.upi.details.*')) active @endif">
                        <h4 class="headline">UPI Details</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.payment.modes.index') }}"
                        class="menu-link @if (Route::is('event.payment.modes.*')) active @endif">
                        <h4 class="headline">Payment Modes</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.config.index') }}"
                        class="menu-link @if (Route::is('event.config.*')) active @endif">
                        <h4 class="headline">Config</h4>
                    </a>
                </li>
            </ul>
        </li>
        <li class="menu-item dropdown-indicator">
            <a class="menu-link @if (Route::is('event.forms.pending.registrations.*') || Route::is('event.forms.confirm.registrations.*')) active @endif" data-bs-toggle="collapse"
                href="#dropdown7" role="button"
                @if (Route::is('event.forms.pending.registrations.*') || Route::is('event.forms.confirm.registrations.*')) aria-expanded="true" @else aria-expanded="false" @endif
                aria-controls="dropdown7" title="Event Speakers">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.4"
                        d="M19.1199 9.11999C18.7299 9.11999 18.4199 9.42999 18.4199 9.81999V11.4C18.4199 14.94 15.5399 17.82 11.9999 17.82C8.45993 17.82 5.57993 14.94 5.57993 11.4V9.80999C5.57993 9.41999 5.26993 9.10999 4.87993 9.10999C4.48993 9.10999 4.17993 9.41999 4.17993 9.80999V11.39C4.17993 15.46 7.30993 18.81 11.2999 19.17V21.3C11.2999 21.69 11.6099 22 11.9999 22C12.3899 22 12.6999 21.69 12.6999 21.3V19.17C16.6799 18.82 19.8199 15.46 19.8199 11.39V9.80999C19.8099 9.42999 19.4999 9.11999 19.1199 9.11999Z"
                        fill="#292D32" />
                    <path
                        d="M12.0001 2C9.56008 2 7.58008 3.98 7.58008 6.42V11.54C7.58008 13.98 9.56008 15.96 12.0001 15.96C14.4401 15.96 16.4201 13.98 16.4201 11.54V6.42C16.4201 3.98 14.4401 2 12.0001 2ZM13.3101 8.95C13.2401 9.21 13.0101 9.38 12.7501 9.38C12.7001 9.38 12.6501 9.37 12.6001 9.36C12.2101 9.25 11.8001 9.25 11.4101 9.36C11.0901 9.45 10.7801 9.26 10.7001 8.95C10.6101 8.64 10.8001 8.32 11.1101 8.24C11.7001 8.08 12.3201 8.08 12.9101 8.24C13.2101 8.32 13.3901 8.64 13.3101 8.95ZM13.8401 7.01C13.7501 7.25 13.5301 7.39 13.2901 7.39C13.2201 7.39 13.1601 7.38 13.0901 7.36C12.3901 7.1 11.6101 7.1 10.9101 7.36C10.6101 7.47 10.2701 7.31 10.1601 7.01C10.0501 6.71 10.2101 6.37 10.5101 6.27C11.4701 5.92 12.5301 5.92 13.4901 6.27C13.7901 6.38 13.9501 6.71 13.8401 7.01Z"
                        fill="#292D32" />
                </svg>
                <h4 class="headline">Registrations</h4>
            </a>
            <ul class="sidenav-submenu collapse @if (Route::is('event.forms.pending.registrations.*') || Route::is('event.forms.confirm.registrations.*')) show @endif" id="dropdown7">
                <li class="menu-item">
                    <a href="{{ route('event.forms.pending.registrations.index') }}"
                        class="menu-link @if (Route::is('event.forms.pending.registrations.*')) active @endif">
                        <h4 class="headline">Pending Registrations</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.forms.confirm.registrations.index') }}"
                        class="menu-link @if (Route::is('event.forms.confirm.registrations.*')) active @endif">
                        <h4 class="headline">Confirm Registrations</h4>
                    </a>
                </li>
            </ul>
        </li>
        <li class="menu-item dropdown-indicator">
            <a class="menu-link @if (Route::is('event.mail.templates.*')) active @endif" data-bs-toggle="collapse"
                href="#dropdown8" role="button"
                @if (Route::is('event.mail.templates.*')) aria-expanded="true" @else aria-expanded="false" @endif
                aria-controls="dropdown8" title="Event Speakers">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M5.71431 4.84999C5.51316 4.84999 5.30143 4.93731 5.13155 5.12448C4.95919 5.3144 4.85002 5.58818 4.85002 5.88888V19.1111C4.85002 19.4118 4.95919 19.6856 5.13155 19.8755C5.30143 20.0627 5.51316 20.15 5.71431 20.15H15.15V12V5.88888C15.15 5.58818 15.0409 5.3144 14.8685 5.12448C14.6986 4.93731 14.4869 4.84999 14.2857 4.84999H5.71431ZM5.71431 21.85H16H18C18.7559 21.85 19.4808 21.5497 20.0153 21.0152C20.5498 20.4808 20.85 19.7559 20.85 19V12C20.85 11.5306 20.4695 11.15 20 11.15H16.85V5.88888C16.85 5.18766 16.598 4.50055 16.1273 3.98199C15.6542 3.4607 14.9939 3.14999 14.2857 3.14999H5.71431C5.00615 3.14999 4.34581 3.4607 3.8727 3.98199C3.40208 4.50055 3.15002 5.18766 3.15002 5.88888V19.1111C3.15002 19.8123 3.40208 20.4994 3.8727 21.018C4.34581 21.5393 5.00615 21.85 5.71431 21.85ZM16.85 20.15V12.85H19.15V19C19.15 19.305 19.0289 19.5975 18.8132 19.8132C18.5975 20.0288 18.305 20.15 18 20.15H16.85ZM8.00002 8.14999C7.53058 8.14999 7.15002 8.53055 7.15002 8.99999C7.15002 9.46944 7.53058 9.84999 8.00002 9.84999H12C12.4695 9.84999 12.85 9.46944 12.85 8.99999C12.85 8.53055 12.4695 8.14999 12 8.14999H8.00002ZM7.15002 12C7.15002 11.5306 7.53058 11.15 8.00002 11.15H12C12.4695 11.15 12.85 11.5306 12.85 12C12.85 12.4694 12.4695 12.85 12 12.85H8.00002C7.53058 12.85 7.15002 12.4694 7.15002 12ZM8.00002 15.15C7.53058 15.15 7.15002 15.5306 7.15002 16C7.15002 16.4694 7.53058 16.85 8.00002 16.85H11C11.4695 16.85 11.85 16.4694 11.85 16C11.85 15.5306 11.4695 15.15 11 15.15H8.00002Z"
                        fill="#7C8DB5" />
                </svg>
                <h4 class="headline">Message/Email</h4>
            </a>
            <ul class="sidenav-submenu collapse @if (Route::is('event.mail.templates.*')) show @endif" id="dropdown8">
                <li class="menu-item">
                    <a href="{{ route('event.mail.templates.index') }}"
                        class="menu-link @if (Route::is('event.mail.templates.*')) active @endif">
                        <h4 class="headline">Email Templates</h4>
                    </a>
                </li>
            </ul>
        </li>
        <li class="menu-item">
            <a href="{{ route('event.member.roles.index') }}"
                class="menu-link  @if (Route::is('event.member.roles*')) active @endif" title="Member Role">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M8.89281 6.2902C8.95947 5.82478 9.1017 5.56808 9.3032 5.39536C9.63851 5.10795 10.363 4.84999 12 4.84999C13.6371 4.84999 14.3615 5.10795 14.6969 5.39536C14.8987 5.56835 15.041 5.82558 15.1075 6.2924C14.2013 6.18944 13.1687 6.14999 12 6.14999C10.83 6.14999 9.79777 6.18956 8.89281 6.2902ZM7.15891 6.60317C7.20285 5.67764 7.42673 4.76473 8.19685 4.10463C9.0282 3.39204 10.3037 3.14999 12 3.14999C13.6963 3.14999 14.9718 3.39204 15.8032 4.10463C16.5763 4.76729 16.7989 5.68473 16.8416 6.61395C17.7273 6.86092 18.4776 7.23419 19.0805 7.79769C20.2614 8.90157 20.6879 10.5594 20.8092 12.7389C20.8357 12.8212 20.85 12.9089 20.85 13C20.85 13.1577 20.8469 13.3169 20.8387 13.4766C20.8466 13.7793 20.85 14.0911 20.85 14.4118C20.85 16.8466 20.5321 18.8446 19.0663 20.1541C17.6393 21.429 15.3374 21.85 12 21.85C10.3152 21.85 8.91604 21.768 7.77127 21.5396C6.62224 21.3105 5.67025 20.9227 4.9347 20.2676C3.45528 18.9499 3.15002 16.8222 3.15002 14C3.15002 13.7798 3.15188 13.5639 3.15601 13.3522C3.15176 13.2342 3.15002 13.1167 3.15002 13C3.15002 12.9331 3.15776 12.868 3.17238 12.8055C3.26457 10.5721 3.67186 8.85715 4.9347 7.73243C5.53531 7.19751 6.28024 6.84081 7.15891 6.60317ZM4.85702 13.341C4.91096 10.9192 5.2797 9.70165 6.06535 9.00193C6.49647 8.61797 7.12781 8.32218 8.10378 8.12752C9.08401 7.93202 10.3515 7.84999 12 7.84999C13.6493 7.84999 14.9142 7.93215 15.8914 8.13297C16.8623 8.3325 17.4892 8.63735 17.9196 9.03961C18.6917 9.76135 19.0647 11.0152 19.1369 13.459C19.1137 13.8253 19.0586 14.1213 18.9613 14.3695C18.837 14.6867 18.6282 14.9658 18.2262 15.2152C17.3434 15.763 15.5692 16.15 12.0061 16.15C8.44326 16.15 6.66526 15.7631 5.77898 15.2147C5.37506 14.9647 5.16503 14.6851 5.03999 14.3679C4.93198 14.094 4.87554 13.7617 4.85702 13.341ZM18.9827 16.743C18.8014 17.7423 18.4647 18.4119 17.9337 18.8863C17.0274 19.696 15.3293 20.15 12 20.15C10.3515 20.15 9.08401 20.068 8.10378 19.8725C7.12781 19.6778 6.49647 19.382 6.06535 18.9981C5.54773 18.537 5.21107 17.8512 5.02619 16.7444C6.37574 17.5116 8.56842 17.85 12.0061 17.85C15.4448 17.85 17.6357 17.5114 18.9827 16.743ZM9.15002 14C9.15002 13.5306 9.53058 13.15 10 13.15H14C14.4695 13.15 14.85 13.5306 14.85 14C14.85 14.4694 14.4695 14.85 14 14.85L10 14.85C9.53058 14.85 9.15002 14.4694 9.15002 14Z"
                        fill="#7C8DB5" />
                </svg>
                <h4 class="headline">Member Roles</h4>
            </a>
        </li>
        <li class="menu-item">
            <a href="{{ route('event.committees.index') }}"
                class="menu-link  @if (Route::is('event.committees*')) active @endif" title="Committee">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M8.89281 6.2902C8.95947 5.82478 9.1017 5.56808 9.3032 5.39536C9.63851 5.10795 10.363 4.84999 12 4.84999C13.6371 4.84999 14.3615 5.10795 14.6969 5.39536C14.8987 5.56835 15.041 5.82558 15.1075 6.2924C14.2013 6.18944 13.1687 6.14999 12 6.14999C10.83 6.14999 9.79777 6.18956 8.89281 6.2902ZM7.15891 6.60317C7.20285 5.67764 7.42673 4.76473 8.19685 4.10463C9.0282 3.39204 10.3037 3.14999 12 3.14999C13.6963 3.14999 14.9718 3.39204 15.8032 4.10463C16.5763 4.76729 16.7989 5.68473 16.8416 6.61395C17.7273 6.86092 18.4776 7.23419 19.0805 7.79769C20.2614 8.90157 20.6879 10.5594 20.8092 12.7389C20.8357 12.8212 20.85 12.9089 20.85 13C20.85 13.1577 20.8469 13.3169 20.8387 13.4766C20.8466 13.7793 20.85 14.0911 20.85 14.4118C20.85 16.8466 20.5321 18.8446 19.0663 20.1541C17.6393 21.429 15.3374 21.85 12 21.85C10.3152 21.85 8.91604 21.768 7.77127 21.5396C6.62224 21.3105 5.67025 20.9227 4.9347 20.2676C3.45528 18.9499 3.15002 16.8222 3.15002 14C3.15002 13.7798 3.15188 13.5639 3.15601 13.3522C3.15176 13.2342 3.15002 13.1167 3.15002 13C3.15002 12.9331 3.15776 12.868 3.17238 12.8055C3.26457 10.5721 3.67186 8.85715 4.9347 7.73243C5.53531 7.19751 6.28024 6.84081 7.15891 6.60317ZM4.85702 13.341C4.91096 10.9192 5.2797 9.70165 6.06535 9.00193C6.49647 8.61797 7.12781 8.32218 8.10378 8.12752C9.08401 7.93202 10.3515 7.84999 12 7.84999C13.6493 7.84999 14.9142 7.93215 15.8914 8.13297C16.8623 8.3325 17.4892 8.63735 17.9196 9.03961C18.6917 9.76135 19.0647 11.0152 19.1369 13.459C19.1137 13.8253 19.0586 14.1213 18.9613 14.3695C18.837 14.6867 18.6282 14.9658 18.2262 15.2152C17.3434 15.763 15.5692 16.15 12.0061 16.15C8.44326 16.15 6.66526 15.7631 5.77898 15.2147C5.37506 14.9647 5.16503 14.6851 5.03999 14.3679C4.93198 14.094 4.87554 13.7617 4.85702 13.341ZM18.9827 16.743C18.8014 17.7423 18.4647 18.4119 17.9337 18.8863C17.0274 19.696 15.3293 20.15 12 20.15C10.3515 20.15 9.08401 20.068 8.10378 19.8725C7.12781 19.6778 6.49647 19.382 6.06535 18.9981C5.54773 18.537 5.21107 17.8512 5.02619 16.7444C6.37574 17.5116 8.56842 17.85 12.0061 17.85C15.4448 17.85 17.6357 17.5114 18.9827 16.743ZM9.15002 14C9.15002 13.5306 9.53058 13.15 10 13.15H14C14.4695 13.15 14.85 13.5306 14.85 14C14.85 14.4694 14.4695 14.85 14 14.85L10 14.85C9.53058 14.85 9.15002 14.4694 9.15002 14Z"
                        fill="#7C8DB5" />
                </svg>
                <h4 class="headline">Committee</h4>
            </a>
        </li>
        <li class="menu-item dropdown-indicator">
            <a class="menu-link @if (Route::is('event.exhibitors.*')) active @endif" data-bs-toggle="collapse"
                href="#dropdown4" role="button"
                @if (Route::is('event.exhibitors.*')) aria-expanded="true" @else aria-expanded="false" @endif
                aria-controls="dropdown4" title="Exhibitors">
                <svg fill="#000000" height="800px" width="800px" version="1.1" id="Capa_1"
                    xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                    viewBox="0 0 507.349 507.349" xml:space="preserve">
                    <g>
                        <path d="M253.67,95.184c17.5,0,31.738-14.237,31.738-31.736c0-17.5-14.238-31.739-31.738-31.739
c-17.496,0-31.73,14.238-31.73,31.739C221.94,80.946,236.174,95.184,253.67,95.184z" />
                        <path d="M135.607,348.129h236.135c4.404,0,7.988-3.584,7.988-7.988v-43.65c0-4.404-3.584-7.988-7.988-7.988h-79.769
c0.025-0.369,0.057-0.737,0.057-1.113v-86.676c0.023-0.241,0.037-0.485,0.037-0.732v-75.029l28.797-30.156
c4.483-4.696,7.615-12.51,7.615-19.002v-62.59c0-7.28-5.923-13.203-13.203-13.203c-7.28,0-13.203,5.923-13.203,13.203v62.308
c-0.077,0.331-0.33,0.964-0.5,1.25l-24.954,26.134h-45.887l-24.954-26.132c-0.172-0.29-0.426-0.923-0.502-1.252V13.203
c0-7.28-5.923-13.203-13.203-13.203S178.87,5.923,178.87,13.203v62.59c0,6.491,3.133,14.305,7.617,19.002l28.795,30.156v75.029
c0,0.576,0.072,1.135,0.197,1.673v85.735c0,0.376,0.031,0.744,0.057,1.113h-79.929c-4.404,0-7.988,3.584-7.988,7.988v43.65
C127.619,344.545,131.203,348.129,135.607,348.129z M247.53,287.389v-79.986h12.449v79.986c0,0.376,0.031,0.744,0.057,1.113
h-12.563C247.498,288.133,247.53,287.765,247.53,287.389z" />
                        <path d="M364.861,394.836c0,15.703,12.773,28.477,28.474,28.477c15.698,0,28.469-12.774,28.469-28.477
c0-15.702-12.771-28.476-28.469-28.476C377.634,366.36,364.861,379.134,364.861,394.836z" />
                        <path d="M453.072,484.975l-26.902-51.57c-2.07-3.971-6.143-6.438-10.627-6.438c-0.192,0-42.614,0.013-42.762,0.024
c-4.196,0.25-7.946,2.657-9.904,6.413l-26.902,51.57c-3.055,5.855-0.776,13.104,5.077,16.156c1.466,0.766,3.036,1.213,4.666,1.329
c0.291,0.021,0.581,0.032,0.87,0.032c4.48,0,8.551-2.468,10.622-6.439l7.775-14.904v20.294c0,3.256,2.649,5.905,5.906,5.905h46.543
c3.258,0,5.907-2.649,5.907-5.905v-21.671l8.493,16.281c2.07,3.972,6.141,6.439,10.623,6.439c0.29,0,0.579-0.011,0.868-0.031
c1.631-0.117,3.201-0.565,4.666-1.329C453.846,498.08,456.125,490.832,453.072,484.975z" />
                        <path d="M224.061,394.836c0,15.703,12.773,28.477,28.474,28.477c15.698,0,28.47-12.774,28.47-28.477
c0-15.702-12.772-28.476-28.47-28.476C236.834,366.36,224.061,379.134,224.061,394.836z" />
                        <path
                            d="M285.371,433.405c-2.07-3.971-6.143-6.438-10.627-6.438c-0.192,0-42.615,0.013-42.763,0.024
c-4.197,0.25-7.947,2.657-9.903,6.413l-26.902,51.57c-3.055,5.855-0.776,13.104,5.077,16.156c1.466,0.766,3.036,1.213,4.665,1.329
c0.291,0.021,0.581,0.032,0.871,0.032c4.48,0,8.551-2.468,10.622-6.439l7.775-14.905v20.295c0,3.256,2.649,5.905,5.906,5.905
h46.542c3.258,0,5.907-2.649,5.907-5.905v-21.671l8.493,16.281c2.07,3.972,6.141,6.439,10.624,6.439
c0.29,0,0.579-0.011,0.868-0.031c1.631-0.117,3.201-0.565,4.666-1.329c5.855-3.053,8.133-10.301,5.079-16.157L285.371,433.405z" />
                        <path d="M111.637,423.313c15.698,0,28.47-12.774,28.47-28.477c0-15.702-12.771-28.476-28.47-28.476
c-15.7,0-28.473,12.773-28.473,28.476C83.164,410.539,95.937,423.313,111.637,423.313z" />
                        <path
                            d="M144.473,433.405c-2.07-3.971-6.143-6.438-10.627-6.438c-0.192,0-42.875,0.03-42.93,0.034l0,0
c-4.129,0.303-7.805,2.697-9.736,6.403l-26.902,51.57c-3.055,5.855-0.776,13.104,5.077,16.156c1.466,0.766,3.037,1.213,4.666,1.329
c0.291,0.021,0.581,0.032,0.87,0.032c4.48,0,8.551-2.468,10.622-6.439l7.775-14.904v20.294c0,3.256,2.649,5.905,5.906,5.905h46.543
c3.257,0,5.906-2.649,5.906-5.905v-21.673l8.494,16.283c2.07,3.972,6.141,6.439,10.623,6.439c0.29,0,0.579-0.011,0.868-0.031
c1.632-0.117,3.202-0.565,4.667-1.33c2.836-1.479,4.926-3.974,5.885-7.025c0.96-3.052,0.673-6.294-0.807-9.131L144.473,433.405z" />
                    </g>
                </svg>
                <h4 class="headline">Exhibitors</h4>
            </a>
            <ul class="sidenav-submenu collapse @if (Route::is('event.exhibitors.*')) show @endif" id="dropdown4">
                <li class="menu-item">
                    <a href="{{ route('event.exhibitors.categories.index') }}"
                        class="menu-link @if (Route::is('event.exhibitors.categories.*')) active @endif">
                        <h4 class="headline">Category</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.exhibitors.index') }}"
                        class="menu-link @if (Route::is('event.exhibitors.index')) active @endif">
                        <h4 class="headline">View All</h4>
                    </a>
                </li>
            </ul>
        </li>
        {{-- <li class="menu-item">
            <a href="{{ route('event.exhibitors.index') }}"
                class="menu-link @if (Route::is('event.exhibitors.*')) active @endif" title="Speaker">
                <svg fill="#000000" height="800px" width="800px" version="1.1" id="Capa_1"
                    xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                    viewBox="0 0 507.349 507.349" xml:space="preserve">
                    <g>
                        <path d="M253.67,95.184c17.5,0,31.738-14.237,31.738-31.736c0-17.5-14.238-31.739-31.738-31.739
  c-17.496,0-31.73,14.238-31.73,31.739C221.94,80.946,236.174,95.184,253.67,95.184z" />
                        <path d="M135.607,348.129h236.135c4.404,0,7.988-3.584,7.988-7.988v-43.65c0-4.404-3.584-7.988-7.988-7.988h-79.769
  c0.025-0.369,0.057-0.737,0.057-1.113v-86.676c0.023-0.241,0.037-0.485,0.037-0.732v-75.029l28.797-30.156
  c4.483-4.696,7.615-12.51,7.615-19.002v-62.59c0-7.28-5.923-13.203-13.203-13.203c-7.28,0-13.203,5.923-13.203,13.203v62.308
  c-0.077,0.331-0.33,0.964-0.5,1.25l-24.954,26.134h-45.887l-24.954-26.132c-0.172-0.29-0.426-0.923-0.502-1.252V13.203
  c0-7.28-5.923-13.203-13.203-13.203S178.87,5.923,178.87,13.203v62.59c0,6.491,3.133,14.305,7.617,19.002l28.795,30.156v75.029
  c0,0.576,0.072,1.135,0.197,1.673v85.735c0,0.376,0.031,0.744,0.057,1.113h-79.929c-4.404,0-7.988,3.584-7.988,7.988v43.65
  C127.619,344.545,131.203,348.129,135.607,348.129z M247.53,287.389v-79.986h12.449v79.986c0,0.376,0.031,0.744,0.057,1.113
  h-12.563C247.498,288.133,247.53,287.765,247.53,287.389z" />
                        <path d="M364.861,394.836c0,15.703,12.773,28.477,28.474,28.477c15.698,0,28.469-12.774,28.469-28.477
  c0-15.702-12.771-28.476-28.469-28.476C377.634,366.36,364.861,379.134,364.861,394.836z" />
                        <path d="M453.072,484.975l-26.902-51.57c-2.07-3.971-6.143-6.438-10.627-6.438c-0.192,0-42.614,0.013-42.762,0.024
  c-4.196,0.25-7.946,2.657-9.904,6.413l-26.902,51.57c-3.055,5.855-0.776,13.104,5.077,16.156c1.466,0.766,3.036,1.213,4.666,1.329
  c0.291,0.021,0.581,0.032,0.87,0.032c4.48,0,8.551-2.468,10.622-6.439l7.775-14.904v20.294c0,3.256,2.649,5.905,5.906,5.905h46.543
  c3.258,0,5.907-2.649,5.907-5.905v-21.671l8.493,16.281c2.07,3.972,6.141,6.439,10.623,6.439c0.29,0,0.579-0.011,0.868-0.031
  c1.631-0.117,3.201-0.565,4.666-1.329C453.846,498.08,456.125,490.832,453.072,484.975z" />
                        <path d="M224.061,394.836c0,15.703,12.773,28.477,28.474,28.477c15.698,0,28.47-12.774,28.47-28.477
  c0-15.702-12.772-28.476-28.47-28.476C236.834,366.36,224.061,379.134,224.061,394.836z" />
                        <path
                            d="M285.371,433.405c-2.07-3.971-6.143-6.438-10.627-6.438c-0.192,0-42.615,0.013-42.763,0.024
  c-4.197,0.25-7.947,2.657-9.903,6.413l-26.902,51.57c-3.055,5.855-0.776,13.104,5.077,16.156c1.466,0.766,3.036,1.213,4.665,1.329
  c0.291,0.021,0.581,0.032,0.871,0.032c4.48,0,8.551-2.468,10.622-6.439l7.775-14.905v20.295c0,3.256,2.649,5.905,5.906,5.905
  h46.542c3.258,0,5.907-2.649,5.907-5.905v-21.671l8.493,16.281c2.07,3.972,6.141,6.439,10.624,6.439
  c0.29,0,0.579-0.011,0.868-0.031c1.631-0.117,3.201-0.565,4.666-1.329c5.855-3.053,8.133-10.301,5.079-16.157L285.371,433.405z" />
                        <path d="M111.637,423.313c15.698,0,28.47-12.774,28.47-28.477c0-15.702-12.771-28.476-28.47-28.476
  c-15.7,0-28.473,12.773-28.473,28.476C83.164,410.539,95.937,423.313,111.637,423.313z" />
                        <path
                            d="M144.473,433.405c-2.07-3.971-6.143-6.438-10.627-6.438c-0.192,0-42.875,0.03-42.93,0.034l0,0
  c-4.129,0.303-7.805,2.697-9.736,6.403l-26.902,51.57c-3.055,5.855-0.776,13.104,5.077,16.156c1.466,0.766,3.037,1.213,4.666,1.329
  c0.291,0.021,0.581,0.032,0.87,0.032c4.48,0,8.551-2.468,10.622-6.439l7.775-14.904v20.294c0,3.256,2.649,5.905,5.906,5.905h46.543
  c3.257,0,5.906-2.649,5.906-5.905v-21.673l8.494,16.283c2.07,3.972,6.141,6.439,10.623,6.439c0.29,0,0.579-0.011,0.868-0.031
  c1.632-0.117,3.202-0.565,4.667-1.33c2.836-1.479,4.926-3.974,5.885-7.025c0.96-3.052,0.673-6.294-0.807-9.131L144.473,433.405z" />
                    </g>
                </svg>
                <h4 class="headline">Exhibitors</h4>
            </a>
        </li> --}}
        <li class="menu-item dropdown-indicator">
            <a class="menu-link @if (Route::is('event.speakers.*')) active @endif" data-bs-toggle="collapse"
                href="#dropdown3" role="button"
                @if (Route::is('event.speakers.*')) aria-expanded="true" @else aria-expanded="false" @endif
                aria-controls="dropdown3" title="Event Speakers">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.4"
                        d="M19.1199 9.11999C18.7299 9.11999 18.4199 9.42999 18.4199 9.81999V11.4C18.4199 14.94 15.5399 17.82 11.9999 17.82C8.45993 17.82 5.57993 14.94 5.57993 11.4V9.80999C5.57993 9.41999 5.26993 9.10999 4.87993 9.10999C4.48993 9.10999 4.17993 9.41999 4.17993 9.80999V11.39C4.17993 15.46 7.30993 18.81 11.2999 19.17V21.3C11.2999 21.69 11.6099 22 11.9999 22C12.3899 22 12.6999 21.69 12.6999 21.3V19.17C16.6799 18.82 19.8199 15.46 19.8199 11.39V9.80999C19.8099 9.42999 19.4999 9.11999 19.1199 9.11999Z"
                        fill="#292D32" />
                    <path
                        d="M12.0001 2C9.56008 2 7.58008 3.98 7.58008 6.42V11.54C7.58008 13.98 9.56008 15.96 12.0001 15.96C14.4401 15.96 16.4201 13.98 16.4201 11.54V6.42C16.4201 3.98 14.4401 2 12.0001 2ZM13.3101 8.95C13.2401 9.21 13.0101 9.38 12.7501 9.38C12.7001 9.38 12.6501 9.37 12.6001 9.36C12.2101 9.25 11.8001 9.25 11.4101 9.36C11.0901 9.45 10.7801 9.26 10.7001 8.95C10.6101 8.64 10.8001 8.32 11.1101 8.24C11.7001 8.08 12.3201 8.08 12.9101 8.24C13.2101 8.32 13.3901 8.64 13.3101 8.95ZM13.8401 7.01C13.7501 7.25 13.5301 7.39 13.2901 7.39C13.2201 7.39 13.1601 7.38 13.0901 7.36C12.3901 7.1 11.6101 7.1 10.9101 7.36C10.6101 7.47 10.2701 7.31 10.1601 7.01C10.0501 6.71 10.2101 6.37 10.5101 6.27C11.4701 5.92 12.5301 5.92 13.4901 6.27C13.7901 6.38 13.9501 6.71 13.8401 7.01Z"
                        fill="#292D32" />
                </svg>
                <h4 class="headline">Event Speakers</h4>
            </a>
            <ul class="sidenav-submenu collapse @if (Route::is('event.speakers.*')) show @endif" id="dropdown3">
                <li class="menu-item">
                    <a href="{{ route('event.speakers.type.index') }}"
                        class="menu-link @if (Route::is('event.speakers.type.*')) active @endif">
                        <h4 class="headline">Type</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.speakers.index') }}"
                        class="menu-link @if (Route::is('event.speakers.index')) active @endif">
                        <h4 class="headline">View All</h4>
                    </a>
                </li>
            </ul>
        </li>
        {{-- <li class="menu-item">
            <a href="{{ route('event.speakers.index') }}"
                class="menu-link @if (Route::is('event.speakers.*')) active @endif" title="Speaker">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.4"
                        d="M19.1199 9.11999C18.7299 9.11999 18.4199 9.42999 18.4199 9.81999V11.4C18.4199 14.94 15.5399 17.82 11.9999 17.82C8.45993 17.82 5.57993 14.94 5.57993 11.4V9.80999C5.57993 9.41999 5.26993 9.10999 4.87993 9.10999C4.48993 9.10999 4.17993 9.41999 4.17993 9.80999V11.39C4.17993 15.46 7.30993 18.81 11.2999 19.17V21.3C11.2999 21.69 11.6099 22 11.9999 22C12.3899 22 12.6999 21.69 12.6999 21.3V19.17C16.6799 18.82 19.8199 15.46 19.8199 11.39V9.80999C19.8099 9.42999 19.4999 9.11999 19.1199 9.11999Z"
                        fill="#292D32" />
                    <path
                        d="M12.0001 2C9.56008 2 7.58008 3.98 7.58008 6.42V11.54C7.58008 13.98 9.56008 15.96 12.0001 15.96C14.4401 15.96 16.4201 13.98 16.4201 11.54V6.42C16.4201 3.98 14.4401 2 12.0001 2ZM13.3101 8.95C13.2401 9.21 13.0101 9.38 12.7501 9.38C12.7001 9.38 12.6501 9.37 12.6001 9.36C12.2101 9.25 11.8001 9.25 11.4101 9.36C11.0901 9.45 10.7801 9.26 10.7001 8.95C10.6101 8.64 10.8001 8.32 11.1101 8.24C11.7001 8.08 12.3201 8.08 12.9101 8.24C13.2101 8.32 13.3901 8.64 13.3101 8.95ZM13.8401 7.01C13.7501 7.25 13.5301 7.39 13.2901 7.39C13.2201 7.39 13.1601 7.38 13.0901 7.36C12.3901 7.1 11.6101 7.1 10.9101 7.36C10.6101 7.47 10.2701 7.31 10.1601 7.01C10.0501 6.71 10.2101 6.37 10.5101 6.27C11.4701 5.92 12.5301 5.92 13.4901 6.27C13.7901 6.38 13.9501 6.71 13.8401 7.01Z"
                        fill="#292D32" />
                </svg>
                <h4 class="headline">Event Speakers</h4>
            </a>
        </li> --}}
        {{-- <li class="menu-item">
            <a href="{{ route('event.faculty.index') }}"
                class="menu-link @if (Route::is('event.faculty.*') || Route::is('event.faculty.*')) active @endif" title="Event Faculty">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="#292D32"
                    viewBox="0 0 24 24">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M16 12h4m-2 2v-4M4 18v-1a3 3 0 0 1 3-3h4a3 3 0 0 1 3 3v1a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1Zm8-10a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                </svg>
                <h4 class="headline">Event Faculty</h4>
            </a>
        </li> --}}
        <li class="menu-item dropdown-indicator">
            <a class="menu-link 
            @if (Route::is('event.days.*') ||
                    Route::is('event.venues.*') ||
                    Route::is('event.important.dates.*') ||
                    Route::is('event.important.links.*') ||
                    Route::is('event.document.lists.*') ||
                    Route::is('event.aboutus.index') ||
                    Route::is('event.aboutCity.index') ||
                    Route::is('event.halls.*') ||
                    Route::is('event.activities.*') ||
                    Route::is('event.banners.*') ||
                    Route::is('event.notices.*')) active @endif"
                data-bs-toggle="collapse" href="#others" role="button"
                @if (Route::is('event.days.*') ||
                        Route::is('event.venues.*') ||
                        Route::is('event.important.dates.*') ||
                        Route::is('event.important.links.*') ||
                        Route::is('event.document.lists.*') ||
                        Route::is('event.aboutus.index') ||
                        Route::is('event.aboutCity.index') ||
                        Route::is('event.halls.*') ||
                        Route::is('event.activities.*') ||
                        Route::is('event.banners.*') ||
                        Route::is('event.notices.*')) aria-expanded="true" @else aria-expanded="false" @endif
                aria-controls="others" title="Event Contact Us">
                <svg width="800px" height="800px" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M12 18H12.01M11 6H13M9.2 21H14.8C15.9201 21 16.4802 21 16.908 20.782C17.2843 20.5903 17.5903 20.2843 17.782 19.908C18 19.4802 18 18.9201 18 17.8V6.2C18 5.0799 18 4.51984 17.782 4.09202C17.5903 3.71569 17.2843 3.40973 16.908 3.21799C16.4802 3 15.9201 3 14.8 3H9.2C8.0799 3 7.51984 3 7.09202 3.21799C6.71569 3.40973 6.40973 3.71569 6.21799 4.09202C6 4.51984 6 5.07989 6 6.2V17.8C6 18.9201 6 19.4802 6.21799 19.908C6.40973 20.2843 6.71569 20.5903 7.09202 20.782C7.51984 21 8.07989 21 9.2 21Z"
                        stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
                <h4 class="headline">Others</h4>
            </a>
            <ul class="sidenav-submenu collapse 
                @if (Route::is('event.days.*') ||
                        Route::is('event.venues.*') ||
                        Route::is('event.important.dates.*') ||
                        Route::is('event.important.links.*') ||
                        Route::is('event.document.lists.*') ||
                        Route::is('event.aboutus.index') ||
                        Route::is('event.aboutCity.index') ||
                        Route::is('event.halls.*') ||
                        Route::is('event.activities.*') ||
                        Route::is('event.banners.*') ||
                        Route::is('event.notices.*')) show @endif"
                id="others">
                <li class="menu-item">
                    <a href="{{ route('event.days.index') }}"
                        class="menu-link @if (Route::is('event.days.*') || Route::is('event.venues.*')) active @endif">
                        <h4 class="headline">Event Days</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.important.dates.index') }}"
                        class="menu-link @if (Route::is('event.important.dates.*')) active @endif">
                        <h4 class="headline">Event Important Dates</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.important.links.index') }}"
                        class="menu-link @if (Route::is('event.important.links.*')) active @endif">
                        <h4 class="headline">Important Links</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.document.lists.index') }}"
                        class="menu-link @if (Route::is('event.document.lists.*')) active @endif">
                        <h4 class="headline">Document List</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.aboutus.index') }}"
                        class="menu-link @if (Route::is('event.aboutus.index')) active @endif">
                        <h4 class="headline">About Us</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.aboutCity.index') }}"
                        class="menu-link @if (Route::is('event.aboutCity.index')) active @endif">
                        <h4 class="headline">About City</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.halls.index') }}"
                        class="menu-link @if (Route::is('event.halls.*')) active @endif">
                        <h4 class="headline">Halls</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.activities.index') }}"
                        class="menu-link @if (Route::is('event.activities.*')) active @endif">
                        <h4 class="headline">Activity</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.banners.index') }}"
                        class="menu-link @if (Route::is('event.banners.*')) active @endif">
                        <h4 class="headline">Banners</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.notices.index') }}"
                        class="menu-link @if (Route::is('event.notices.*')) active @endif">
                        <h4 class="headline">Notice</h4>
                    </a>
                </li>
            </ul>
        </li>


        <li class="menu-item">
            <a href="{{ route('event.coordinators.index') }}"
                class="menu-link  @if (Route::is('event.coordinators.*')) active @endif" title="Event Coordinators">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M6.60537 6.51378C8.19355 7.05875 9.85686 5.9649 10.1523 4.45575C10.334 3.6714 10.5472 3.3284 10.7588 3.15285C10.963 2.9834 11.3113 2.84999 12.0681 2.84999C12.6537 2.84999 12.9861 2.99729 13.2032 3.2013C13.4367 3.42073 13.6532 3.81471 13.7831 4.52742L13.7831 4.52742L13.7839 4.53188C13.9393 5.35915 14.5089 5.98299 15.1709 6.3281C15.8348 6.67419 16.6677 6.78319 17.4529 6.50676C17.4638 6.50292 17.4746 6.49885 17.4854 6.49457C18.2385 6.19431 18.6479 6.20024 18.8979 6.28468C19.1438 6.36773 19.4259 6.5908 19.7749 7.18204C20.1315 7.78636 20.1785 8.1088 20.1376 8.32686C20.0947 8.55514 19.9137 8.8927 19.2772 9.42088L19.2655 9.43072C17.9883 10.5298 17.9883 12.4701 19.2655 13.5693L19.2772 13.5791C19.9137 14.1073 20.0947 14.4448 20.1376 14.6731C20.1785 14.8912 20.1315 15.2136 19.7749 15.8179C19.4279 16.4058 19.1416 16.6392 18.8818 16.7328C18.6166 16.8283 18.1994 16.8428 17.4486 16.5868C15.9258 16.0535 14.076 16.9607 13.7817 18.6708C13.6509 19.4305 13.4405 19.7311 13.2525 19.8767C13.0499 20.0337 12.6968 20.15 11.9699 20.15C11.2703 20.15 10.9103 20.0198 10.6988 19.8501C10.4938 19.6856 10.2861 19.3694 10.1574 18.6662C9.86052 16.9591 8.01275 16.054 6.49126 16.5867C5.74049 16.8428 5.3233 16.8283 5.05808 16.7328C4.79834 16.6392 4.51204 16.4058 4.16504 15.8179C4.16029 15.8099 4.15541 15.8019 4.15039 15.794C3.84533 15.3141 3.81342 14.9815 3.878 14.7201C3.95058 14.4262 4.18745 14.0489 4.7567 13.5825L4.77249 13.5693C6.07171 12.4512 5.92902 10.5134 4.67803 9.52704C4.11043 8.97074 3.93322 8.61707 3.89204 8.36078C3.85285 8.11685 3.90914 7.78512 4.25594 7.19432C4.574 6.6978 4.86758 6.48716 5.15516 6.39857C5.46392 6.30346 5.90804 6.3048 6.60537 6.51378ZM12.0681 1.14999C11.1567 1.14999 10.3275 1.30159 9.67315 1.84463C9.02738 2.38052 8.70223 3.17439 8.49211 4.08984C8.48957 4.10088 8.48726 4.11197 8.48517 4.12311C8.37911 4.68781 7.70759 5.09964 7.14969 4.90323C7.13774 4.89902 7.1257 4.89508 7.11357 4.89141C6.25006 4.63016 5.42296 4.53725 4.65468 4.77391C3.86511 5.01714 3.2779 5.5639 2.81381 6.29402C2.8088 6.30192 2.80391 6.30989 2.79916 6.31794C2.3674 7.04945 2.08131 7.80732 2.21357 8.63046C2.34332 9.438 2.84692 10.1206 3.52868 10.7807C3.55389 10.8051 3.58058 10.8279 3.60861 10.849C4.07858 11.2029 4.11427 11.8861 3.66994 12.2752C2.96812 12.8521 2.42399 13.5173 2.2276 14.3124C2.02343 15.139 2.23349 15.9423 2.70805 16.6939C3.1449 17.4308 3.69105 18.0473 4.48191 18.3322C5.27117 18.6165 6.12879 18.5071 7.04414 18.1943L7.04416 18.1944L7.05157 18.1918C7.68665 17.9682 8.38504 18.3908 8.48288 18.9592L8.48284 18.9592L8.48434 18.9674C8.65007 19.8766 8.98177 20.6521 9.63502 21.1762C10.2821 21.6952 11.0996 21.85 11.9699 21.85C12.8131 21.85 13.6375 21.7288 14.2935 21.2208C14.9641 20.7013 15.2934 19.9095 15.457 18.9592C15.5549 18.3908 16.2532 17.9682 16.8883 18.1918L16.8883 18.1918L16.8958 18.1943C17.8111 18.5071 18.6687 18.6165 19.458 18.3322C20.2531 18.0458 20.8008 17.4242 21.2389 16.682C21.6672 15.9564 21.9636 15.1863 21.8083 14.3594C21.6554 13.5452 21.1035 12.8868 20.3696 12.2765C19.887 11.8565 19.887 11.1435 20.3696 10.7235C21.1035 10.1132 21.6554 9.45483 21.8083 8.64063C21.9636 7.81368 21.6672 7.04363 21.2389 6.31794C20.8028 5.57918 20.2508 4.94726 19.4419 4.67406C18.6426 4.40414 17.7828 4.54864 16.8749 4.90785C16.5837 5.00575 16.2451 4.97098 15.9567 4.82064C15.6628 4.66739 15.4965 4.43702 15.455 4.21978C15.2904 3.31864 14.9673 2.52618 14.3673 1.96243C13.7504 1.3827 12.9543 1.14999 12.0681 1.14999ZM9.85002 11.5C9.85002 10.3126 10.8126 9.34999 12 9.34999C13.1874 9.34999 14.15 10.3126 14.15 11.5C14.15 12.6874 13.1874 13.65 12 13.65C10.8126 13.65 9.85002 12.6874 9.85002 11.5ZM12 7.64999C9.87372 7.64999 8.15002 9.3737 8.15002 11.5C8.15002 13.6263 9.87372 15.35 12 15.35C14.1263 15.35 15.85 13.6263 15.85 11.5C15.85 9.3737 14.1263 7.64999 12 7.64999Z"
                        fill="#7C8DB5" />
                </svg>
                <h4 class="headline">Event Coordinators</h4>
            </a>
        </li>

        <li class="menu-item dropdown-indicator">
            <a class="menu-link @if (Route::is('event.sessions.*') || Route::is('event.designations.*')) active @endif" data-bs-toggle="collapse"
                href="#dropdown1" role="button"
                @if (Route::is('event.sessions.*')) aria-expanded="true" @else aria-expanded="false" @endif
                aria-controls="dropdown1" title="Sessions">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M5.71431 4.84999C5.51316 4.84999 5.30143 4.93731 5.13155 5.12448C4.95919 5.3144 4.85002 5.58818 4.85002 5.88888V19.1111C4.85002 19.4118 4.95919 19.6856 5.13155 19.8755C5.30143 20.0627 5.51316 20.15 5.71431 20.15H15.15V12V5.88888C15.15 5.58818 15.0409 5.3144 14.8685 5.12448C14.6986 4.93731 14.4869 4.84999 14.2857 4.84999H5.71431ZM5.71431 21.85H16H18C18.7559 21.85 19.4808 21.5497 20.0153 21.0152C20.5498 20.4808 20.85 19.7559 20.85 19V12C20.85 11.5306 20.4695 11.15 20 11.15H16.85V5.88888C16.85 5.18766 16.598 4.50055 16.1273 3.98199C15.6542 3.4607 14.9939 3.14999 14.2857 3.14999H5.71431C5.00615 3.14999 4.34581 3.4607 3.8727 3.98199C3.40208 4.50055 3.15002 5.18766 3.15002 5.88888V19.1111C3.15002 19.8123 3.40208 20.4994 3.8727 21.018C4.34581 21.5393 5.00615 21.85 5.71431 21.85ZM16.85 20.15V12.85H19.15V19C19.15 19.305 19.0289 19.5975 18.8132 19.8132C18.5975 20.0288 18.305 20.15 18 20.15H16.85ZM8.00002 8.14999C7.53058 8.14999 7.15002 8.53055 7.15002 8.99999C7.15002 9.46944 7.53058 9.84999 8.00002 9.84999H12C12.4695 9.84999 12.85 9.46944 12.85 8.99999C12.85 8.53055 12.4695 8.14999 12 8.14999H8.00002ZM7.15002 12C7.15002 11.5306 7.53058 11.15 8.00002 11.15H12C12.4695 11.15 12.85 11.5306 12.85 12C12.85 12.4694 12.4695 12.85 12 12.85H8.00002C7.53058 12.85 7.15002 12.4694 7.15002 12ZM8.00002 15.15C7.53058 15.15 7.15002 15.5306 7.15002 16C7.15002 16.4694 7.53058 16.85 8.00002 16.85H11C11.4695 16.85 11.85 16.4694 11.85 16C11.85 15.5306 11.4695 15.15 11 15.15H8.00002Z"
                        fill="#7C8DB5" />
                </svg>
                <h4 class="headline">Sessions</h4>
            </a>
            <ul class="sidenav-submenu collapse @if (Route::is('event.sessions.*') || Route::is('event.designations.*')) show @endif" id="dropdown1">
                <li class="menu-item">
                    <a href="{{ route('event.sessions.index') }}"
                        class="menu-link @if (Route::is('event.sessions.*')) active @endif">
                        <h4 class="headline">Session</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.designations.index') }}"
                        class="menu-link @if (Route::is('event.designations.*')) active @endif">
                        <h4 class="headline">Session Designation</h4>
                    </a>
                </li>
            </ul>
        </li>
        <li class="menu-item dropdown-indicator">
            <a class="menu-link @if (Route::is('event.eposter.category.*') || Route::is('event.e-poster.*')) active @endif" data-bs-toggle="collapse"
                href="#dropdown2" role="button"
                @if (Route::is('event.eposter.category.*') || Route::is('event.e-poster.*')) aria-expanded="true" @else aria-expanded="false" @endif
                aria-controls="dropdown2" title="E-Posters">
                <svg width="800px" height="800px" viewBox="0 0 24 24" id="Layer_1" data-name="Layer 1"
                    xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                    <defs>
                        <style>
                            .cls-1 {
                                fill: none;
                            }

                            .cls-2 {
                                clip-path: url(#clip-path);
                            }
                        </style>
                        <clipPath id="clip-path">
                            <rect class="cls-1" y="0.09" width="24" height="24" />
                        </clipPath>
                    </defs>
                    <title>poster</title>
                    <g class="cls-2">
                        <path
                            d="M2.43,22.12a1.07,1.07,0,0,1-.25,0,1,1,0,0,1-.72-1.21L6,2.64a1,1,0,0,1,1-.76h11a1,1,0,0,1,.77.37,1,1,0,0,1,.21.83L15.26,21.31a1,1,0,1,1-2-.39l3.41-17H7.77L3.4,21.36A1,1,0,0,1,2.43,22.12Z" />
                        <path d="M3.34,18.47a1,1,0,0,1,0-2l11.68,0h0a1,1,0,0,1,0,2l-11.68,0Z" />
                        <path
                            d="M21.57,22.12a1,1,0,0,1-1-.74l-2.74-10a1,1,0,0,1,.71-1.23,1,1,0,0,1,1.22.71l2.74,10a1,1,0,0,1-.7,1.22A.84.84,0,0,1,21.57,22.12Z" />
                        <path
                            d="M10.63,22.12a1,1,0,0,1-.93-.65L8.33,17.82a1,1,0,1,1,1.87-.7l1.37,3.65A1,1,0,0,1,11,22.05.84.84,0,0,1,10.63,22.12Z" />
                        <path d="M13.82,9.35H8.35a1,1,0,0,1,0-2h5.47a1,1,0,0,1,0,2Z" />
                        <path d="M12.91,13H7.44a1,1,0,0,1,0-2h5.47a1,1,0,0,1,0,2Z" />
                    </g>
                </svg>
                <h4 class="headline">E-Posters</h4>
            </a>
            <ul class="sidenav-submenu collapse @if (Route::is('event.eposter.category.*') || Route::is('event.eposter.*')) show @endif" id="dropdown2">
                <li class="menu-item">
                    <a href="{{ route('event.eposter.category.index') }}"
                        class="menu-link @if (Route::is('event.eposter.category.*')) active @endif">
                        <h4 class="headline">Category</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.eposter.index') }}"
                        class="menu-link @if (Route::is('event.eposter.index')) active @endif">
                        <h4 class="headline">View All</h4>
                    </a>
                </li>
            </ul>
        </li>
        <li class="menu-item dropdown-indicator">
            <a class="menu-link @if (Route::is('event.contact.us.*')) active @endif" data-bs-toggle="collapse"
                href="#dropdown5" role="button"
                @if (Route::is('event.contact.us.*')) aria-expanded="true" @else aria-expanded="false" @endif
                aria-controls="dropdown5" title="Event Contact Us">
                <svg fill="#000000" version="1.1" id="XMLID_276_" xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 24 24" xml:space="preserve">
                    <g id="contact-us">
                        <g>
                            <path d="M4,24v-5H0V0h23v19h-9.3L4,24z M2,17h4v3.7l7.3-3.7H21V2H2V17z" />
                        </g>
                        <g>
                            <rect x="5" y="8" width="3" height="3" />
                        </g>
                        <g>
                            <rect x="10" y="8" width="3" height="3" />
                        </g>
                        <g>
                            <rect x="15" y="8" width="3" height="3" />
                        </g>
                    </g>
                </svg>
                <h4 class="headline">Event Contact Us</h4>
            </a>
            <ul class="sidenav-submenu collapse @if (Route::is('event.contact.us.*')) show @endif" id="dropdown5">
                <li class="menu-item">
                    <a href="{{ route('event.contact.us.type.index') }}"
                        class="menu-link @if (Route::is('event.contact.us.type.*')) active @endif">
                        <h4 class="headline">Type</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.contact.us.index') }}"
                        class="menu-link @if (Route::is('event.contact.us.index')) active @endif">
                        <h4 class="headline">View All</h4>
                    </a>
                </li>
            </ul>
        </li>
        <li class="menu-item">
            <a href="{{ route('event.notifications.index') }}"
                class="menu-link  @if (Route::is('event.notifications.*')) active @endif" title="Notifications">
                <svg width="800px" height="800px" viewBox="0 0 24 24" version="1.1"
                    xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">

                    <title>notice-active</title>
                    <desc>Created with sketchtool.</desc>
                    <g id="web-app" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="notice-active" fill="#000000">
                            <path
                                d="M15.0846417,4.85258583 C15.3698859,3.78571001 16.3431867,3 17.5,3 C18.8807119,3 20,4.11928813 20,5.5 C20,6.82802369 18.9645064,7.9141949 17.6568748,7.99515796 C17.8790698,8.62208363 18,9.29691944 18,10 L18,16 L19,16 C19.5499992,16 20,16.4500008 20,17 C20,17.5499992 19.5499992,18 19,18 L15,18 L15,19 C15,20.6568542 13.6568542,22 12,22 C10.3431458,22 9,20.6568542 9,19 L9,18 L5,18 C4.44999981,18 4,17.5499992 4,17 C4,16.4500008 4.44999981,16 5,16 L6,16 L6,10 C6,7.02700371 8.16228666,4.55903653 11,4.08295844 L11,3 C11,2.44771525 11.4477153,2 12,2 C12.5522847,2 13,2.44771525 13,3 L13,4.08295844 C13.7514465,4.20902728 14.4555302,4.47477291 15.0846417,4.85258583 Z M12,20 C12.5522847,20 13,19.5522847 13,19 C13,18.7251922 13,18.3918589 13,18 L11,18 C11,18.470365 11,18.8036984 11,19 C11,19.5522847 11.4477153,20 12,20 Z M8,16 L16,16 L16,10 C16,7.790861 14.209139,6 12,6 C9.790861,6 8,7.790861 8,10 L8,16 Z"
                                id="Shape">

                            </path>
                        </g>
                    </g>
                </svg>
                <h4 class="headline">Notifications</h4>
            </a>
        </li>
        <li class="menu-item dropdown-indicator">
            <a class="menu-link @if (Route::is('event.app.home.buttons*') ||
                    Route::is('event.app.sponsor.links.*') ||
                    Route::is('event.app.dashboard.sponsor.links.*')) active @endif" data-bs-toggle="collapse"
                href="#dropdown6" role="button"
                @if (Route::is('event.app.home.buttons*')) aria-expanded="true" @else aria-expanded="false" @endif
                aria-controls="dropdown6" title="App">
                <svg width="800px" height="800px" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M12 18H12.01M11 6H13M9.2 21H14.8C15.9201 21 16.4802 21 16.908 20.782C17.2843 20.5903 17.5903 20.2843 17.782 19.908C18 19.4802 18 18.9201 18 17.8V6.2C18 5.0799 18 4.51984 17.782 4.09202C17.5903 3.71569 17.2843 3.40973 16.908 3.21799C16.4802 3 15.9201 3 14.8 3H9.2C8.0799 3 7.51984 3 7.09202 3.21799C6.71569 3.40973 6.40973 3.71569 6.21799 4.09202C6 4.51984 6 5.07989 6 6.2V17.8C6 18.9201 6 19.4802 6.21799 19.908C6.40973 20.2843 6.71569 20.5903 7.09202 20.782C7.51984 21 8.07989 21 9.2 21Z"
                        stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
                <h4 class="headline">App</h4>
            </a>
            <ul class="sidenav-submenu collapse @if (Route::is('event.app.home.buttons.*') ||
                    Route::is('event.app.sponsor.links.*') ||
                    Route::is('event.app.dashboard.sponsor.links.*')) show @endif" id="dropdown6">
                <li class="menu-item">
                    <a href="{{ route('event.app.home.buttons.index') }}"
                        class="menu-link @if (Route::is('event.app.home.buttons.*')) active @endif">
                        <h4 class="headline">Home Buttons</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.app.sponsor.links.index') }}"
                        class="menu-link @if (Route::is('event.app.sponsor.links.*')) active @endif">
                        <h4 class="headline">Sponsor Links</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.app.dashboard.sponsor.links.index') }}"
                        class="menu-link @if (Route::is('event.app.dashboard.sponsor.links.*')) active @endif">
                        <h4 class="headline">Dashboard Sponsor Links</h4>
                    </a>
                </li>
            </ul>
        </li>
        <li class="menu-item">
            <a href="{{ route('event.settings.index') }}"
                class="menu-link  @if (Route::is('event.settings.*')) active @endif" title="Settings">
                <svg width="800px" height="800px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#000000"
                        d="M600.704 64a32 32 0 0 1 30.464 22.208l35.2 109.376c14.784 7.232 28.928 15.36 42.432 24.512l112.384-24.192a32 32 0 0 1 34.432 15.36L944.32 364.8a32 32 0 0 1-4.032 37.504l-77.12 85.12a357.12 357.12 0 0 1 0 49.024l77.12 85.248a32 32 0 0 1 4.032 37.504l-88.704 153.6a32 32 0 0 1-34.432 15.296L708.8 803.904c-13.44 9.088-27.648 17.28-42.368 24.512l-35.264 109.376A32 32 0 0 1 600.704 960H423.296a32 32 0 0 1-30.464-22.208L357.696 828.48a351.616 351.616 0 0 1-42.56-24.64l-112.32 24.256a32 32 0 0 1-34.432-15.36L79.68 659.2a32 32 0 0 1 4.032-37.504l77.12-85.248a357.12 357.12 0 0 1 0-48.896l-77.12-85.248A32 32 0 0 1 79.68 364.8l88.704-153.6a32 32 0 0 1 34.432-15.296l112.32 24.256c13.568-9.152 27.776-17.408 42.56-24.64l35.2-109.312A32 32 0 0 1 423.232 64H600.64zm-23.424 64H446.72l-36.352 113.088-24.512 11.968a294.113 294.113 0 0 0-34.816 20.096l-22.656 15.36-116.224-25.088-65.28 113.152 79.68 88.192-1.92 27.136a293.12 293.12 0 0 0 0 40.192l1.92 27.136-79.808 88.192 65.344 113.152 116.224-25.024 22.656 15.296a294.113 294.113 0 0 0 34.816 20.096l24.512 11.968L446.72 896h130.688l36.48-113.152 24.448-11.904a288.282 288.282 0 0 0 34.752-20.096l22.592-15.296 116.288 25.024 65.28-113.152-79.744-88.192 1.92-27.136a293.12 293.12 0 0 0 0-40.256l-1.92-27.136 79.808-88.128-65.344-113.152-116.288 24.96-22.592-15.232a287.616 287.616 0 0 0-34.752-20.096l-24.448-11.904L577.344 128zM512 320a192 192 0 1 1 0 384 192 192 0 0 1 0-384zm0 64a128 128 0 1 0 0 256 128 128 0 0 0 0-256z" />
                </svg>
                <h4 class="headline">Settings</h4>
            </a>
        </li>
        <li class="menu-item">
            <a href="{{ route('event.logout') }}"
                onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                class="menu-link logout" title="Log out">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M3.85002 12C3.85002 9.99114 3.85029 8.45417 3.91141 7.26228C3.97333 6.05473 4.09509 5.30104 4.28923 4.81568C4.45864 4.39214 4.66921 4.20038 4.9956 4.07345C5.39632 3.91761 6.00387 3.84999 7.00002 3.84999C7.97383 3.84999 8.65326 3.91173 9.12813 4.01725C9.60149 4.12244 9.80451 4.25656 9.89898 4.35103C9.98323 4.43528 10.0546 4.56044 10.0991 4.82723C10.1476 5.11838 10.15 5.47843 10.15 5.99999C10.15 6.46944 10.5306 6.84999 11 6.84999C11.4695 6.84999 11.85 6.46944 11.85 5.99999L11.85 5.95742V5.95741C11.8501 5.49111 11.8502 4.99303 11.776 4.54775C11.6954 4.06455 11.5168 3.56471 11.1011 3.14895C10.6955 2.74342 10.1486 2.50254 9.49692 2.35773C8.84679 2.21326 8.02622 2.14999 7.00002 2.14999C5.99618 2.14999 5.10373 2.20737 4.37945 2.48904C3.58084 2.79961 3.04141 3.35785 2.71082 4.18431C2.40496 4.94895 2.27671 5.94526 2.21364 7.17521C2.15002 8.41571 2.15002 9.99583 2.15002 11.9755V11.9757V12V12.0243V12.0245C2.15002 14.0042 2.15002 15.5843 2.21364 16.8248C2.27671 18.0547 2.40496 19.051 2.71082 19.8157C3.04141 20.6421 3.58084 21.2004 4.37945 21.5109C5.10373 21.7926 5.99618 21.85 7.00002 21.85C8.02622 21.85 8.84679 21.7867 9.49692 21.6423C10.1486 21.4974 10.6955 21.2566 11.1011 20.851C11.5168 20.4353 11.6954 19.9354 11.776 19.4522C11.8502 19.007 11.8501 18.5089 11.85 18.0426V18.0426L11.85 18C11.85 17.5306 11.4695 17.15 11 17.15C10.5306 17.15 10.15 17.5306 10.15 18C10.15 18.5216 10.1476 18.8816 10.0991 19.1728C10.0546 19.4395 9.98323 19.5647 9.89898 19.649C9.80451 19.7434 9.60149 19.8775 9.12813 19.9827C8.65326 20.0883 7.97383 20.15 7.00002 20.15C6.00387 20.15 5.39632 20.0824 4.9956 19.9265C4.66921 19.7996 4.45864 19.6078 4.28923 19.1843C4.09509 18.699 3.97333 17.9453 3.91141 16.7377C3.85029 15.5458 3.85002 14.0088 3.85002 12ZM17.6011 7.39895C17.2691 7.06701 16.7309 7.06701 16.399 7.39895C16.067 7.7309 16.067 8.26909 16.399 8.60103L18.9479 11.15H11C10.5306 11.15 10.15 11.5306 10.15 12C10.15 12.4694 10.5306 12.85 11 12.85H18.9479L16.399 15.399C16.067 15.7309 16.067 16.2691 16.399 16.601C16.7309 16.933 17.2691 16.933 17.6011 16.601L21.6011 12.601C21.933 12.2691 21.933 11.7309 21.6011 11.399L17.6011 7.39895Z"
                        fill="#7C8DB5" />
                </svg>
                <h4 class="headline">Log out</h4>
            </a>
            <form id="logout-form" action="{{ route('event.logout') }}" method="POST" class="d-none">
                @csrf
            </form>
        </li>
    </ul>

</div>
