<?php

use App\Enums\RoleEnum;
use App\Helpers\MetaClient;
use App\Http\Controllers\Association\AssociationNotificationController;
use App\Http\Controllers\Association\BannerController;
use App\Http\Controllers\Association\CalendarController;
use App\Http\Controllers\Association\CommitteeController;
use App\Http\Controllers\Association\EventController;
use App\Http\Controllers\Association\EventManagerController;
use App\Http\Controllers\Association\EventRegistrationController;
use App\Http\Controllers\Association\InternationalAffiliationController;
use App\Http\Controllers\Association\MemberController;
use App\Http\Controllers\Association\MemberRoleController;
use App\Http\Controllers\Association\MembershipFormController;
use App\Http\Controllers\Association\NoticeController;
use App\Http\Controllers\Association\PastOfficeBearerController;
use App\Http\Controllers\Association\PollController;
use App\Http\Controllers\Association\PollOptionController;
use App\Http\Controllers\Association\PostController;
use App\Http\Controllers\Association\SettingController;
use App\Http\Controllers\Association\SliderController;
use Illuminate\Support\Facades\Route;


Route::middleware(['auth', 'isValidRole:' . RoleEnum::ASSOCIATION])->group(function () {
    // Route::get("test-meta", function () {
    //     $api = new MetaClient();
    //     $response = $api->getMessageTemplates();
    //     $json = $response->json();
    //     dd($json);
    // });

    Route::prefix('membership-form')->name('membership.form.')->group(function () {
        Route::get('/', [MembershipFormController::class, 'index'])->name('index');
        Route::put('/', [MembershipFormController::class, 'storeField'])->name('store');
        Route::get('/field/{membershipFormField}', [MembershipFormController::class, 'editField'])->name('edit');
        Route::put('/field/{membershipFormField}', [MembershipFormController::class, 'updateFields'])->name('update');
        Route::delete('/field/{membershipFormField}', [MembershipFormController::class, 'deleteField'])->name('delete');
    });

    Route::prefix('sliders')->name('sliders.')->group(function () {
        Route::get('/', [SliderController::class, 'index'])->name('index');
        Route::get('/add', [SliderController::class, 'create'])->name('create');
        Route::post('/', [SliderController::class, 'store'])->name('store');
        Route::get('/{slider}', [SliderController::class, 'edit'])->name('edit');
        Route::put('/{slider}', [SliderController::class, 'update'])->name('update');
        Route::delete('/{slider}', [SliderController::class, 'destroy'])->name('destroy');
        Route::patch('/{slider}', [SliderController::class, 'statusChange'])->name('status');
    });

    Route::prefix('banners')->name('banners.')->group(function () {
        Route::get('/', [BannerController::class, 'index'])->name('index');
        Route::get('/add', [BannerController::class, 'create'])->name('create');
        Route::post('/', [BannerController::class, 'store'])->name('store');
        Route::get('/{banner}', [BannerController::class, 'edit'])->name('edit');
        Route::put('/{banner}', [BannerController::class, 'update'])->name('update');
        Route::delete('/{banner}', [BannerController::class, 'destroy'])->name('destroy');
        Route::patch('/{banner}', [BannerController::class, 'statusChange'])->name('status');
    });

    Route::prefix('member-roles')->name('member.roles.')->group(function () {
        Route::get('/', [MemberRoleController::class, 'index'])->name('index');
        Route::get('/add', [MemberRoleController::class, 'create'])->name('create');
        Route::post('/', [MemberRoleController::class, 'store'])->name('store');
        Route::get('/{memberRole}', [MemberRoleController::class, 'edit'])->name('edit');
        Route::put('/{memberRole}', [MemberRoleController::class, 'update'])->name('update');
        Route::delete('/{memberRole}', [MemberRoleController::class, 'destroy'])->name('destroy');
        Route::patch('/{memberRole}', [MemberRoleController::class, 'statusChange'])->name('status');
        Route::post('/update/{memberRole}', [MemberRoleController::class, 'updateIndex'])->name('update.index');
    });

    Route::prefix('members')->name('members.')->group(function () {
        Route::get('/', [MemberController::class, 'index'])->name('index');
        Route::get('/add', [MemberController::class, 'create'])->name('create');
        Route::post('/', [MemberController::class, 'store'])->name('store');
        Route::get('/{user}', [MemberController::class, 'edit'])->name('edit');
        Route::put('/{user}', [MemberController::class, 'update'])->name('update');
        Route::delete('/{user}', [MemberController::class, 'destroy'])->name('destroy');
        Route::patch('/{user}', [MemberController::class, 'statusChange'])->name('status');
        Route::get('/view/{user}', [MemberController::class, 'view'])->name('view');
        Route::post('/import/{associationId}', [MemberController::class, 'import'])->name('import');
    });

    Route::get('/search', [MemberController::class, 'search'])->name('members.search');

    Route::prefix('committees')->name('committees.')->group(function () {
        Route::get('/', [CommitteeController::class, 'index'])->name('index');
        Route::get('/add', [CommitteeController::class, 'create'])->name('create');
        Route::post('/', [CommitteeController::class, 'store'])->name('store');
        Route::get('/{committee}', [CommitteeController::class, 'edit'])->name('edit');
        Route::put('/{committee}', [CommitteeController::class, 'update'])->name('update');
        Route::delete('/{committee}', [CommitteeController::class, 'destroy'])->name('destroy');
        Route::patch('/{committee}', [CommitteeController::class, 'statusChange'])->name('status');
        Route::post('/update/{committee}', [CommitteeController::class, 'updateCommiteeIndex'])->name('update.index');

        Route::get('/{committee}/view', [CommitteeController::class, 'view'])->name('view');
        Route::prefix('members')->name('members.')->group(function () {
            Route::get('/{committee}', [CommitteeController::class, 'createMember'])->name('create');
            Route::post('/{committee}', [CommitteeController::class, 'addMember'])->name('store');
            Route::delete('/{committeeMember}', [CommitteeController::class, 'destroyMember'])->name('destroy');
            Route::post('/update/{committeeMember}', [CommitteeController::class, 'updateIndex'])->name('update.index');
        });
    });

    Route::prefix('association/settings')->name('association.settings.')->group(function () {
        Route::get('/', [SettingController::class, 'index'])->name('index');
        Route::post('/', [SettingController::class, 'update'])->name('store');
    });

    Route::prefix('events')->name('events.')->group(function () {
        Route::get('/', [EventController::class, 'index'])->name('index');
        Route::get('/add', [EventController::class, 'create'])->name('create');
        Route::post('/add', [EventController::class, 'store'])->name('store');
        Route::get('/{event}', [EventController::class, 'edit'])->name('edit');
        Route::put('/{event}', [EventController::class, 'update'])->name('update');
        Route::delete('/{event}', [EventController::class, 'destroy'])->name('destroy');
        Route::patch('/{event}', [EventController::class, 'statusChange'])->name('status');

        Route::prefix('participants')->name('participants.')->group(function () {
            Route::get('/{event}', [EventRegistrationController::class, 'index'])->name('index');
            Route::delete('/events/{eventRegistration}/registrations', [EventRegistrationController::class, 'delete'])->name('delete');
        });
        Route::prefix('managers')->name('manager.')->group(function () {
            Route::get('/list', [EventManagerController::class, 'index'])->name('index');
            Route::get('/add', [EventManagerController::class, 'create'])->name('create');
            Route::post('/add', [EventManagerController::class, 'store'])->name('store');
            Route::get('/{eventManager}', [EventManagerController::class, 'edit'])->name('edit');
            Route::put('/{eventManager}', [EventManagerController::class, 'update'])->name('update');
            Route::delete('/{eventManager}', [EventManagerController::class, 'destroy'])->name('destroy');
        });
    });


    Route::prefix('notices')->name('notices.')->group(function () {
        Route::get('/', [NoticeController::class, 'index'])->name('index');
        Route::get('/add', [NoticeController::class, 'create'])->name('create');
        Route::post('/', [NoticeController::class, 'store'])->name('store');
        Route::get('/{notice}', [NoticeController::class, 'edit'])->name('edit');
        Route::put('/{notice}', [NoticeController::class, 'update'])->name('update');
        Route::delete('/{notice}', [NoticeController::class, 'destroy'])->name('destroy');
        Route::patch('/{notice}', [NoticeController::class, 'statusChange'])->name('status');
    });

    Route::prefix('calendars')->name('calendars.')->group(function () {
        Route::get('/', [CalendarController::class, 'index'])->name('index');
        Route::get('/add', [CalendarController::class, 'create'])->name('create');
        Route::post('/add', [CalendarController::class, 'store'])->name('store');
        Route::get('/{calendar}', [CalendarController::class, 'edit'])->name('edit');
        Route::put('/{calendar}', [CalendarController::class, 'update'])->name('update');
        Route::delete('/{calendar}', [CalendarController::class, 'destroy'])->name('destroy');
        Route::patch('/{calendar}', [CalendarController::class, 'statusChange'])->name('status');
    });

    Route::prefix('past-office-bearers')->name('past.office.bearers.')->group(function () {
        Route::get('/', [PastOfficeBearerController::class, 'index'])->name('index');
        Route::get('/add', [PastOfficeBearerController::class, 'create'])->name('create');
        Route::post('/add', [PastOfficeBearerController::class, 'store'])->name('store');
        Route::get('/{pastOffBearer}', [PastOfficeBearerController::class, 'edit'])->name('edit');
        Route::put('/{pastOffBearer}', [PastOfficeBearerController::class, 'update'])->name('update');
        Route::delete('/{pastOffBearer}', [PastOfficeBearerController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('international-affiliations')->name('international.affiliations.')->group(function () {
        Route::get('/', [InternationalAffiliationController::class, 'index'])->name('index');
        Route::get('/add', [InternationalAffiliationController::class, 'create'])->name('create');
        Route::post('/add', [InternationalAffiliationController::class, 'store'])->name('store');
        Route::get('/{internationalAffiliation}', [InternationalAffiliationController::class, 'edit'])->name('edit');
        Route::put('/{internationalAffiliation}', [InternationalAffiliationController::class, 'update'])->name('update');
        Route::patch('/{internationalAffiliation}', [InternationalAffiliationController::class, 'statusChange'])->name('status');
        Route::delete('/{internationalAffiliation}', [InternationalAffiliationController::class, 'destroy'])->name('destroy');
        Route::post('/update/{internationalAffiliation}', [InternationalAffiliationController::class, 'updateIndex'])->name('update.index');
    });

    Route::prefix('notifications')->name('notifications.')->group(function () {
        Route::get('/', [AssociationNotificationController::class, 'index'])->name('index');
        Route::get('/add', [AssociationNotificationController::class, 'create'])->name('create');
        Route::post('/add', [AssociationNotificationController::class, 'store'])->name('store');
        Route::delete('/{notification}', [AssociationNotificationController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('polls')->name('polls.')->group(function () {
        Route::get('/', [PollController::class, 'index'])->name('index');
        Route::get('/add', [PollController::class, 'create'])->name('create');
        Route::post('/add', [PollController::class, 'store'])->name('store');
        Route::get('/{poll}', [PollController::class, 'edit'])->name('edit');
        Route::put('/{poll}', [PollController::class, 'update'])->name('update');
        Route::delete('/{poll}', [PollController::class, 'destroy'])->name('destroy');
        Route::patch('/{poll}', [PollController::class, 'statusChange'])->name('status');
        Route::patch('type/{poll}', [PollController::class, 'typeChange'])->name('type');

        Route::prefix('options')->name('options.')->group(function () {
            Route::get('/{poll}', [PollOptionController::class, 'index'])->name('index');
            Route::get('/add/{poll}', [PollOptionController::class, 'create'])->name('create');
            Route::post('/add/{poll}', [PollOptionController::class, 'store'])->name('store');
            Route::get('edit/{pollOption}', [PollOptionController::class, 'edit'])->name('edit');
            Route::put('update/{pollOption}', [PollOptionController::class, 'update'])->name('update');
            Route::delete('/{pollOption}', [PollOptionController::class, 'destroy'])->name('destroy');
            Route::patch('type/{pollOption}', [PollOptionController::class, 'typeChange'])->name('type');
        });
    });

    Route::prefix('association/posts')->name('association.posts.')->group(function () {
        Route::get('/', [PostController::class, 'index'])->name('index');
        Route::delete('/{post}', [PostController::class, 'destroy'])->name('destroy');
    });
});
