<?php

use App\Http\Controllers\FireBaseController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\TestController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;

require __DIR__ . '/super_admin.php';
require __DIR__ . '/association.php';
require __DIR__ . '/event.php';
require __DIR__ . '/event_coordinator.php';

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('/optimize', function () {
    Artisan::call('optimize');
    return 'Optimized.';
});

Route::get('/add-association-users', function () {
    Artisan::call('add-data-in-association-user-command');
    return 'Data added successfully';
});

Auth::routes();

Route::get('/home', [HomeController::class, 'index'])->name('home');

Route::get('/migrate', function () {
    Artisan::call('migrate');
    return "Migration run Successfully !";
});

require __DIR__ . '/root.php';
